/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.fetcher;

import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class LatestEventFetcher {
    private final EventLatestRepository eventLatestRepository;
    private final int bulkItems;

    public Flowable<List<Event>> fetchLatest(Long from, Long to, Event.EventProperties group, List<String> environments, Set<EventType> eventTypes) {
        return Flowable.generate(() -> EventPageable.builder().index(0L).size(this.bulkItems).criteria(EventCriteria.builder().types((Collection)eventTypes).from(from == null ? -1L : from - 30000L).to(to == null ? -1L : to + 30000L).environments((Collection)environments).build()).build(), (page, emitter) -> {
            try {
                List events = this.eventLatestRepository.search(page.criteria, group, Long.valueOf(page.index), Long.valueOf(page.size));
                if (events != null && !events.isEmpty()) {
                    emitter.onNext((Object)events);
                    ++page.index;
                }
                if (events == null || (long)events.size() < page.size) {
                    emitter.onComplete();
                }
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        });
    }

    @Generated
    public LatestEventFetcher(EventLatestRepository eventLatestRepository, int bulkItems) {
        this.eventLatestRepository = eventLatestRepository;
        this.bulkItems = bulkItems;
    }

    @Generated
    public int bulkItems() {
        return this.bulkItems;
    }

    private static class EventPageable {
        private long index;
        private long size;
        private EventCriteria criteria;

        @Generated
        public static EventPageableBuilder builder() {
            return new EventPageableBuilder();
        }

        @Generated
        public EventPageable(long index, long size, EventCriteria criteria) {
            this.index = index;
            this.size = size;
            this.criteria = criteria;
        }

        @Generated
        public long getIndex() {
            return this.index;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public EventCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public static class EventPageableBuilder {
            @Generated
            private long index;
            @Generated
            private long size;
            @Generated
            private EventCriteria criteria;

            @Generated
            EventPageableBuilder() {
            }

            @Generated
            public EventPageableBuilder index(long index) {
                this.index = index;
                return this;
            }

            @Generated
            public EventPageableBuilder size(long size) {
                this.size = size;
                return this;
            }

            @Generated
            public EventPageableBuilder criteria(EventCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public EventPageable build() {
                return new EventPageable(this.index, this.size, this.criteria);
            }

            @Generated
            public String toString() {
                return "LatestEventFetcher.EventPageable.EventPageableBuilder(index=" + this.index + ", size=" + this.size + ", criteria=" + this.criteria + ")";
            }
        }
    }
}

