/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.synchronizer.organization;

import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.deployer.OrganizationDeployer;
import io.gravitee.gateway.services.sync.process.distributed.fetcher.DistributedEventFetcher;
import io.gravitee.gateway.services.sync.process.distributed.mapper.OrganizationMapper;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.AbstractDistributedSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.gravitee.repository.distributedsync.model.DistributedSyncAction;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedOrganizationSynchronizer
extends AbstractDistributedSynchronizer<OrganizationDeployable, OrganizationDeployer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistributedOrganizationSynchronizer.class);
    private final DeployerFactory deployerFactory;
    private final OrganizationMapper organizationMapper;

    public DistributedOrganizationSynchronizer(DistributedEventFetcher distributedEventFetcher, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor, DeployerFactory deployerFactory, OrganizationMapper organizationMapper) {
        super(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor);
        this.deployerFactory = deployerFactory;
        this.organizationMapper = organizationMapper;
    }

    @Override
    protected DistributedEventType distributedEventType() {
        return DistributedEventType.ORGANIZATION;
    }

    @Override
    protected Set<DistributedSyncAction> syncActions(boolean initialSync) {
        return INIT_SYNC_ACTIONS;
    }

    @Override
    protected Maybe<OrganizationDeployable> mapTo(DistributedEvent distributedEvent) {
        return this.organizationMapper.to(distributedEvent);
    }

    @Override
    protected OrganizationDeployer createDeployer() {
        return this.deployerFactory.createOrganizationDeployer();
    }

    @Override
    public int order() {
        return 40;
    }
}

