/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.services.sync.process.common.model.SubscriptionDeployable;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SyncActionMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription.SingleSubscriptionDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionMapper.class);
    private final ObjectMapper objectMapper;

    public Maybe<SingleSubscriptionDeployable> to(DistributedEvent event) {
        return Maybe.fromCallable(() -> {
            try {
                Subscription subscription = (Subscription)this.objectMapper.readValue(event.getPayload(), Subscription.class);
                return SingleSubscriptionDeployable.builder().subscription(subscription).syncAction(SyncActionMapper.to(event.getSyncAction())).build();
            }
            catch (Exception e) {
                log.warn("Error while determining subscription into event payload", (Throwable)e);
                return null;
            }
        });
    }

    public Flowable<DistributedEvent> to(SubscriptionDeployable deployable) {
        return Flowable.fromIterable(deployable.subscriptions()).flatMapMaybe(subscription -> Maybe.fromCallable(() -> {
            try {
                DistributedEvent.DistributedEventBuilder builder = DistributedEvent.builder().id(subscription.getId()).type(DistributedEventType.SUBSCRIPTION).syncAction(SyncActionMapper.to(deployable.syncAction())).updatedAt(new Date()).refType(DistributedEventType.API).refId(deployable.apiId());
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    builder.payload(this.objectMapper.writeValueAsString(subscription));
                }
                return builder.build();
            }
            catch (Exception e) {
                log.warn("Error while building distributed event from subscription", (Throwable)e);
                return null;
            }
        }));
    }

    @Generated
    public SubscriptionMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

