/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.gravitee.repository.distributedsync.model.DistributedSyncAction;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationMapper.class);
    private final ObjectMapper objectMapper;

    public Maybe<OrganizationDeployable> to(DistributedEvent event) {
        return Maybe.fromCallable(() -> {
            try {
                ReactableOrganization reactableOrganization = (ReactableOrganization)this.objectMapper.readValue(event.getPayload(), ReactableOrganization.class);
                return OrganizationDeployable.builder().reactableOrganization(reactableOrganization).build();
            }
            catch (Exception e) {
                log.warn("Error while determining deployed organization into event payload", (Throwable)e);
                return null;
            }
        });
    }

    public Maybe<DistributedEvent> to(OrganizationDeployable organizationDeployable) {
        return Maybe.fromCallable(() -> {
            try {
                return DistributedEvent.builder().id(organizationDeployable.id()).type(DistributedEventType.ORGANIZATION).syncAction(DistributedSyncAction.DEPLOY).payload(this.objectMapper.writeValueAsString((Object)organizationDeployable.reactableOrganization())).updatedAt(new Date()).build();
            }
            catch (Exception e) {
                log.warn("Error while building distributed event from organization", (Throwable)e);
                return null;
            }
        });
    }

    @Generated
    public OrganizationMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

