/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.services.sync.SyncManager;
import io.gravitee.gateway.services.sync.healthcheck.SyncProcessProbe;
import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.ProbeManager;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class SyncService
extends AbstractService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncService.class);
    @Value(value="${services.sync.enabled:true}")
    private boolean enabled;
    @Autowired
    private ApiManager apiManager;
    @Autowired(required=false)
    private List<SyncManager> syncManagers;
    @Autowired
    private ProbeManager probeManager;
    @Autowired
    private SyncProcessProbe syncProcessProbe;

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.probeManager.register((Probe)this.syncProcessProbe);
            this.apiManager.refresh();
            if (this.syncManagers != null) {
                this.syncManagers.forEach(syncManager -> {
                    try {
                        syncManager.start();
                    }
                    catch (Exception e) {
                        log.error("Unable to start sync manager {}", (Object)syncManager.getClass().getSimpleName(), (Object)e);
                    }
                });
            }
        } else {
            log.warn("Sync service is disabled");
        }
    }

    protected void doStop() throws Exception {
        if (this.syncManagers != null) {
            this.syncManagers.forEach(syncManager -> {
                try {
                    syncManager.stop();
                }
                catch (Exception e) {
                    log.error("Unable to start sync manager {}", (Object)syncManager.getClass().getSimpleName(), (Object)e);
                    throw new RuntimeException(e);
                }
            });
        }
        super.doStop();
    }

    protected String name() {
        return "Gateway Sync Service";
    }
}

