/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.debug;

import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.services.sync.process.common.deployer.DebugDeployer;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.DebugEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.DebugMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.debug.DebugDeployable;
import io.gravitee.repository.management.model.Event;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugSynchronizer
implements RepositorySynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugSynchronizer.class);
    private final DebugEventFetcher debugEventFetcher;
    private final DebugMapper debugMapperMapper;
    private final DeployerFactory deployerFactory;
    private final ThreadPoolExecutor syncFetcherExecutor;
    private final ThreadPoolExecutor syncDeployerExecutor;

    @Override
    public Completable synchronize(Long from, Long to, List<String> environments) {
        if (from == -1L) {
            return Completable.complete();
        }
        AtomicLong launchTime = new AtomicLong();
        return this.debugEventFetcher.fetchLatest(from, to, environments).subscribeOn(Schedulers.from((Executor)this.syncFetcherExecutor)).flatMap(events -> Flowable.just((Object)events).flatMapIterable(e -> e).flatMapMaybe(event -> this.debugMapperMapper.to((Event)event).map(reactable -> ((DebugDeployable.DebugDeployableBuilder)((DebugDeployable.DebugDeployableBuilder)DebugDeployable.builder().id(event.getId())).reactable((Reactable)reactable)).build()))).compose(upstream -> {
            DebugDeployer debugDeployer = this.deployerFactory.createDebugDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(debugDeployable -> debugDeployer.deploy((DebugDeployable)debugDeployable).andThen((CompletableSource)debugDeployer.doAfterDeployment(debugDeployable)).andThen((Publisher)Flowable.just((Object)debugDeployable)).onErrorResumeNext(throwable -> {
                log.error(throwable.getMessage(), throwable);
                return Flowable.empty();
            })).sequential();
        }).count().doOnSubscribe(disposable -> launchTime.set(Instant.now().toEpochMilli())).doOnSuccess(count -> log.debug("{} debug events refreshed in {}ms", count, (Object)(System.currentTimeMillis() - launchTime.get()))).ignoreElement();
    }

    @Override
    public int order() {
        return 40;
    }

    @Generated
    public DebugSynchronizer(DebugEventFetcher debugEventFetcher, DebugMapper debugMapperMapper, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.debugEventFetcher = debugEventFetcher;
        this.debugMapperMapper = debugMapperMapper;
        this.deployerFactory = deployerFactory;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

