/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey;

import io.gravitee.gateway.api.service.ApiKey;
import io.gravitee.gateway.services.sync.process.common.model.ApiKeyDeployable;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class SingleApiKeyDeployable
implements ApiKeyDeployable {
    @NonNull
    private ApiKey apiKey;
    private SyncAction syncAction;

    @Override
    public String id() {
        return this.apiKey.getId();
    }

    @Override
    public String apiId() {
        return this.apiKey.getApi();
    }

    @Override
    public Set<String> apiKeyPlans() {
        return Set.of(this.apiKey.getPlan());
    }

    @Override
    public List<ApiKey> apiKeys() {
        return List.of(this.apiKey);
    }

    @Override
    public SingleApiKeyDeployable apiKeys(List<ApiKey> apiKeys) {
        throw new UnsupportedOperationException(String.format("Unable to override apikey for %s", SingleApiKeyDeployable.class.getName()));
    }

    @Generated
    SingleApiKeyDeployable(@NonNull ApiKey apiKey, SyncAction syncAction) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.syncAction = syncAction;
    }

    @Generated
    public static SingleApiKeyDeployableBuilder builder() {
        return new SingleApiKeyDeployableBuilder();
    }

    @NonNull
    @Generated
    public ApiKey apiKey() {
        return this.apiKey;
    }

    @Override
    @Generated
    public SyncAction syncAction() {
        return this.syncAction;
    }

    @Generated
    public SingleApiKeyDeployable apiKey(@NonNull ApiKey apiKey) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        this.apiKey = apiKey;
        return this;
    }

    @Generated
    public SingleApiKeyDeployable syncAction(SyncAction syncAction) {
        this.syncAction = syncAction;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleApiKeyDeployable)) {
            return false;
        }
        SingleApiKeyDeployable other = (SingleApiKeyDeployable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiKey this$apiKey = this.apiKey();
        ApiKey other$apiKey = other.apiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        SyncAction this$syncAction = this.syncAction();
        SyncAction other$syncAction = other.syncAction();
        return !(this$syncAction == null ? other$syncAction != null : !((Object)((Object)this$syncAction)).equals((Object)other$syncAction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SingleApiKeyDeployable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiKey $apiKey = this.apiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        SyncAction $syncAction = this.syncAction();
        result = result * 59 + ($syncAction == null ? 43 : ((Object)((Object)$syncAction)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SingleApiKeyDeployable(apiKey=" + this.apiKey() + ", syncAction=" + this.syncAction() + ")";
    }

    @Generated
    public static class SingleApiKeyDeployableBuilder {
        @Generated
        private ApiKey apiKey;
        @Generated
        private SyncAction syncAction;

        @Generated
        SingleApiKeyDeployableBuilder() {
        }

        @Generated
        public SingleApiKeyDeployableBuilder apiKey(@NonNull ApiKey apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SingleApiKeyDeployableBuilder syncAction(SyncAction syncAction) {
            this.syncAction = syncAction;
            return this;
        }

        @Generated
        public SingleApiKeyDeployable build() {
            return new SingleApiKeyDeployable(this.apiKey, this.syncAction);
        }

        @Generated
        public String toString() {
            return "SingleApiKeyDeployable.SingleApiKeyDeployableBuilder(apiKey=" + this.apiKey + ", syncAction=" + this.syncAction + ")";
        }
    }
}

