/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import io.gravitee.gateway.api.service.ApiKey;
import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.search.ApiKeyCriteria;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyAppender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeyAppender.class);
    private final ApiKeyRepository apiKeyRepository;
    private final ApiKeyMapper apiKeyMapper;

    public List<ApiReactorDeployable> appends(boolean initialSync, List<ApiReactorDeployable> deployables) {
        Map<String, ApiReactorDeployable> deployableByApi = deployables.stream().collect(Collectors.toMap(ApiReactorDeployable::apiId, d -> d));
        List<Subscription> allApiKeySubscriptions = deployableByApi.values().stream().filter(deployable -> deployable.subscriptions() != null && deployable.apiKeyPlans() != null).flatMap(deployable -> deployable.subscriptions().stream().filter(subscription -> subscription.getPlan() != null && deployable.apiKeyPlans().contains(subscription.getPlan()))).collect(Collectors.toList());
        if (!allApiKeySubscriptions.isEmpty()) {
            Map<String, List<ApiKey>> apiKeyByApi = this.loadApiKey(initialSync, allApiKeySubscriptions);
            apiKeyByApi.forEach((api, apiKeys) -> {
                ApiReactorDeployable deployable = (ApiReactorDeployable)deployableByApi.get(api);
                deployable.apiKeys((List)apiKeys);
            });
        }
        return deployables;
    }

    private Map<String, List<ApiKey>> loadApiKey(boolean initialSync, List<Subscription> subscriptions) {
        try {
            Map<String, Subscription> subscriptionsById = subscriptions.stream().collect(Collectors.toMap(Subscription::getId, s -> s));
            ApiKeyCriteria.ApiKeyCriteriaBuilder criteriaBuilder = ApiKeyCriteria.builder().subscriptions(subscriptionsById.keySet());
            if (initialSync) {
                criteriaBuilder.includeRevoked(false).expireAfter(Instant.now().toEpochMilli()).includeWithoutExpiration(true);
            } else {
                criteriaBuilder.includeRevoked(true);
            }
            List bySubscriptions = this.apiKeyRepository.findByCriteria(criteriaBuilder.build(), new SortableBuilder().field("updatedAt").order(Order.ASC).build());
            return bySubscriptions.stream().flatMap(apiKey -> apiKey.getSubscriptions().stream().map(subscriptionsById::get).filter(Objects::nonNull).map(subscription -> this.apiKeyMapper.to((io.gravitee.repository.management.model.ApiKey)apiKey, (Subscription)subscription))).collect(Collectors.groupingBy(ApiKey::getApi));
        }
        catch (Exception ex) {
            throw new SyncException("Error occurred when retrieving API Keys", ex);
        }
    }

    @Generated
    public ApiKeyAppender(ApiKeyRepository apiKeyRepository, ApiKeyMapper apiKeyMapper) {
        this.apiKeyRepository = apiKeyRepository;
        this.apiKeyMapper = apiKeyMapper;
    }
}

