/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.synchronizer.api;

import io.gravitee.gateway.handlers.api.manager.ActionOnApi;
import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.common.deployer.ApiDeployer;
import io.gravitee.gateway.services.sync.process.common.deployer.ApiKeyDeployer;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.common.deployer.SubscriptionDeployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.flowables.GroupedFlowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiSynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractApiSynchronizer.class);
    protected final ApiManager apiManager;
    protected final ApiMapper apiMapper;
    protected final PlanAppender planAppender;
    protected final SubscriptionAppender subscriptionAppender;
    protected final ApiKeyAppender apiKeyAppender;
    protected final DeployerFactory deployerFactory;
    protected final ThreadPoolExecutor syncFetcherExecutor;
    protected final ThreadPoolExecutor syncDeployerExecutor;

    protected abstract int bulkEvents();

    protected Flowable<ApiReactorDeployable> processEvents(boolean initialSync, Flowable<List<Event>> eventsFlowable) {
        return eventsFlowable.flatMap(events -> Flowable.just((Object)events).doOnNext(e -> log.debug("New api events fetch")).flatMapIterable(e -> e).groupBy(Event::getType).flatMap(eventsByType -> {
            if (eventsByType.getKey() == EventType.PUBLISH_API || eventsByType.getKey() == EventType.START_API) {
                return this.prepareForDeployment(initialSync, (GroupedFlowable<EventType, Event>)eventsByType);
            }
            if (eventsByType.getKey() == EventType.UNPUBLISH_API || eventsByType.getKey() == EventType.STOP_API) {
                return this.prepareForUndeployment((Flowable<Event>)eventsByType);
            }
            return Flowable.empty();
        })).compose(upstream -> {
            SubscriptionDeployer subscriptionDeployer = this.deployerFactory.createSubscriptionDeployer();
            ApiKeyDeployer apiKeyDeployer = this.deployerFactory.createApiKeyDeployer();
            ApiDeployer apiDeployer = this.deployerFactory.createApiDeployer();
            return upstream.parallel(this.syncDeployerExecutor.getMaximumPoolSize()).runOn(Schedulers.from((Executor)this.syncDeployerExecutor)).flatMap(deployable -> {
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    return this.deployApi(subscriptionDeployer, apiKeyDeployer, apiDeployer, (ApiReactorDeployable)deployable);
                }
                if (deployable.syncAction() == SyncAction.UNDEPLOY) {
                    return this.undeployApi(subscriptionDeployer, apiKeyDeployer, apiDeployer, (ApiReactorDeployable)deployable);
                }
                return Flowable.just((Object)deployable);
            }).sequential(this.bulkEvents());
        });
    }

    private Flowable<ApiReactorDeployable> prepareForDeployment(boolean initialSync, GroupedFlowable<EventType, Event> eventsByType) {
        return eventsByType.flatMapMaybe(this.apiMapper::to).groupBy(arg_0 -> ((ApiManager)this.apiManager).requiredActionFor(arg_0)).flatMap(reactableByAction -> {
            if (reactableByAction.getKey() == ActionOnApi.DEPLOY) {
                return reactableByAction.map(reactableApi -> ApiReactorDeployable.builder().apiId(reactableApi.getId()).syncAction(SyncAction.DEPLOY).reactableApi((ReactableApi<?>)reactableApi).build()).buffer(this.bulkEvents()).map(this.planAppender::appends).map(deployables -> this.subscriptionAppender.appends(initialSync, (List<ApiReactorDeployable>)deployables)).map(deployables -> this.apiKeyAppender.appends(initialSync, (List<ApiReactorDeployable>)deployables)).flatMapIterable(d -> d);
            }
            if (reactableByAction.getKey() == ActionOnApi.UNDEPLOY) {
                return reactableByAction.map(reactableApi -> ApiReactorDeployable.builder().syncAction(SyncAction.UNDEPLOY).apiId(reactableApi.getId()).build());
            }
            return Flowable.empty();
        });
    }

    private Flowable<ApiReactorDeployable> prepareForUndeployment(Flowable<Event> eventsByType) {
        return eventsByType.flatMapMaybe(this.apiMapper::toId).map(apiId -> ApiReactorDeployable.builder().syncAction(SyncAction.UNDEPLOY).apiId((String)apiId).build());
    }

    private Flowable<ApiReactorDeployable> deployApi(SubscriptionDeployer subscriptionDeployer, ApiKeyDeployer apiKeyDeployer, ApiDeployer apiDeployer, ApiReactorDeployable deployable) {
        return subscriptionDeployer.deploy(deployable).andThen((CompletableSource)apiKeyDeployer.deploy(deployable)).andThen((CompletableSource)apiDeployer.deploy(deployable)).andThen((CompletableSource)subscriptionDeployer.doAfterDeployment(deployable)).andThen((CompletableSource)apiKeyDeployer.doAfterDeployment(deployable)).andThen((CompletableSource)apiDeployer.doAfterDeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    private Flowable<ApiReactorDeployable> undeployApi(SubscriptionDeployer subscriptionDeployer, ApiKeyDeployer apiKeyDeployer, ApiDeployer apiDeployer, ApiReactorDeployable deployable) {
        return apiDeployer.undeploy(deployable).andThen((CompletableSource)subscriptionDeployer.undeploy(deployable)).andThen((CompletableSource)apiKeyDeployer.undeploy(deployable)).andThen((CompletableSource)subscriptionDeployer.doAfterUndeployment(deployable)).andThen((CompletableSource)apiKeyDeployer.doAfterUndeployment(deployable)).andThen((CompletableSource)apiDeployer.doAfterUndeployment(deployable)).andThen((Publisher)Flowable.just((Object)deployable)).onErrorResumeNext(throwable -> {
            log.error(throwable.getMessage(), throwable);
            return Flowable.empty();
        });
    }

    @Generated
    public AbstractApiSynchronizer(ApiManager apiManager, ApiMapper apiMapper, PlanAppender planAppender, SubscriptionAppender subscriptionAppender, ApiKeyAppender apiKeyAppender, DeployerFactory deployerFactory, ThreadPoolExecutor syncFetcherExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        this.apiManager = apiManager;
        this.apiMapper = apiMapper;
        this.planAppender = planAppender;
        this.subscriptionAppender = subscriptionAppender;
        this.apiKeyAppender = apiKeyAppender;
        this.deployerFactory = deployerFactory;
        this.syncFetcherExecutor = syncFetcherExecutor;
        this.syncDeployerExecutor = syncDeployerExecutor;
    }
}

