/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.handlers.api.services.SubscriptionCacheService;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.distributed.DistributedSynchronizer;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.DefaultSyncManager;
import io.gravitee.gateway.services.sync.process.repository.RepositorySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.fetcher.ApiKeyFetcher;
import io.gravitee.gateway.services.sync.process.repository.fetcher.DebugEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.fetcher.LatestEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.fetcher.SubscriptionFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.DebugMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.DictionaryMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.OrganizationMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.repository.service.EnvironmentService;
import io.gravitee.gateway.services.sync.process.repository.service.PlanService;
import io.gravitee.gateway.services.sync.process.repository.spring.RepositorySyncCondition;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey.ApiKeySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.debug.DebugSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary.DictionarySynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.FlowAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription.SubscriptionSynchronizer;
import io.gravitee.node.api.Node;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.vertx.ext.web.Router;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RepositorySyncCondition.class})
public class RepositorySyncConfiguration {
    @Bean
    public DictionaryMapper dictionaryMapper(ObjectMapper objectMapper) {
        return new DictionaryMapper(objectMapper);
    }

    @Bean
    public OrganizationMapper organizationMapper(ObjectMapper objectMapper) {
        return new OrganizationMapper(objectMapper);
    }

    @Bean
    public DebugMapper debugMapper(EnvironmentService environmentService) {
        return new DebugMapper(environmentService);
    }

    @Bean
    public LatestEventFetcher eventFetcher(EventLatestRepository eventLatestRepository, @Value(value="${services.sync.bulk_items:100}") int bulkItems) {
        return new LatestEventFetcher(eventLatestRepository, bulkItems);
    }

    @Bean
    public SubscriptionFetcher subscriptionFetcher(SubscriptionRepository subscriptionRepository) {
        return new SubscriptionFetcher(subscriptionRepository);
    }

    @Bean
    public ApiKeyFetcher apiKeyFetcher(ApiKeyRepository apiKeyRepository) {
        return new ApiKeyFetcher(apiKeyRepository);
    }

    @Bean
    public DebugEventFetcher debugEventFetcher(EventRepository eventRepository, Node node) {
        return new DebugEventFetcher(eventRepository, node);
    }

    @Bean
    public FlowAppender flowAppender(GatewayConfiguration gatewayConfiguration) {
        return new FlowAppender(gatewayConfiguration);
    }

    @Bean
    public ApiSynchronizer apiSynchronizer(LatestEventFetcher eventsFetcher, ApiManager apiManager, ApiMapper apiMapper, PlanAppender planAppender, SubscriptionAppender subscriptionAppender, ApiKeyAppender apiKeyAppender, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new ApiSynchronizer(eventsFetcher, apiManager, apiMapper, planAppender, subscriptionAppender, apiKeyAppender, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public SubscriptionSynchronizer subscriptionSynchronizer(SubscriptionFetcher subscriptionFetcher, SubscriptionMapper subscriptionMapper, PlanService planCache, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new SubscriptionSynchronizer(subscriptionFetcher, subscriptionMapper, deployerFactory, planCache, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public ApiKeySynchronizer apiKeySynchronizer(ApiKeyFetcher apiKeyFetcher, SubscriptionCacheService subscriptionService, ApiKeyMapper apiKeyMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new ApiKeySynchronizer(apiKeyFetcher, subscriptionService, apiKeyMapper, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public DictionarySynchronizer dictionarySynchronizer(LatestEventFetcher eventsFetcher, DictionaryMapper dictionaryMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DictionarySynchronizer(eventsFetcher, dictionaryMapper, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public OrganizationSynchronizer organizationSynchronizer(LatestEventFetcher eventsFetcher, OrganizationMapper organizationMapper, FlowAppender flowAppender, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new OrganizationSynchronizer(eventsFetcher, organizationMapper, flowAppender, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public DebugSynchronizer debugSynchronizer(DebugEventFetcher debugEventFetcher, DebugMapper debugMapperMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DebugSynchronizer(debugEventFetcher, debugMapperMapper, deployerFactory, syncFetcherExecutor, syncDeployerExecutor);
    }

    @Bean
    public DefaultSyncManager syncManager(@Qualifier(value="managementRouter") Router router, Node node, List<RepositorySynchronizer> synchronizers, @Autowired(required=false) List<DistributedSynchronizer> distributedSynchronizers, DistributedSyncService distributedSyncService, @Value(value="${services.sync.delay:5000}") int delay, @Value(value="${services.sync.unit:MILLISECONDS}") TimeUnit unit, @Value(value="${services.sync.retry:3}") int retryAttempt) {
        return new DefaultSyncManager(router, node, synchronizers, distributedSynchronizers, distributedSyncService, delay, unit, retryAttempt);
    }
}

