/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.service;

import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Organization;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentService.class);
    private final EnvironmentRepository environmentRepository;
    private final OrganizationRepository organizationRepository;
    private final Map<String, Environment> environments = new ConcurrentHashMap<String, Environment>();
    private final Map<String, Organization> organizations = new ConcurrentHashMap<String, Organization>();

    public void fill(String environmentId, ReactableApi<?> reactableApi) {
        Environment apiEnv;
        if (environmentId != null && (apiEnv = this.loadEnvironment(environmentId)) != null) {
            reactableApi.setEnvironmentId(apiEnv.getId());
            reactableApi.setEnvironmentHrid(apiEnv.getHrids() != null ? (String)apiEnv.getHrids().stream().findFirst().orElse(null) : null);
            Organization apiOrg = this.organizations.get(apiEnv.getOrganizationId());
            if (apiOrg != null) {
                reactableApi.setOrganizationId(apiOrg.getId());
                reactableApi.setOrganizationHrid(apiOrg.getHrids() != null ? (String)apiOrg.getHrids().stream().findFirst().orElse(null) : null);
            }
        }
    }

    private Environment loadEnvironment(String environmentId) {
        return this.environments.computeIfAbsent(environmentId, envId -> {
            try {
                Optional environmentOpt = this.environmentRepository.findById(envId);
                if (environmentOpt.isPresent()) {
                    Environment environment = (Environment)environmentOpt.get();
                    this.loadOrganization(environment);
                    return environment;
                }
            }
            catch (Exception e) {
                log.warn("An error occurred fetching the environment '{}' and its organization.", envId, (Object)e);
            }
            return null;
        });
    }

    private void loadOrganization(Environment environment) {
        this.organizations.computeIfAbsent(environment.getOrganizationId(), orgId -> {
            try {
                return this.organizationRepository.findById(orgId).orElse(null);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    @Generated
    public EnvironmentService(EnvironmentRepository environmentRepository, OrganizationRepository organizationRepository) {
        this.environmentRepository = environmentRepository;
        this.organizationRepository = organizationRepository;
    }
}

