/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.fetcher;

import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.Subscription;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import lombok.Generated;

public class SubscriptionFetcher {
    private static final List<String> STATUSES = List.of(Subscription.Status.ACCEPTED.name(), Subscription.Status.CLOSED.name(), Subscription.Status.PAUSED.name(), Subscription.Status.PENDING.name());
    private final SubscriptionRepository subscriptionRepository;

    public Flowable<List<Subscription>> fetchLatest(Long from, Long to) {
        return Flowable.generate(emitter -> {
            SubscriptionCriteria criteriaBuilder = SubscriptionCriteria.builder().statuses(STATUSES).from(from == null ? -1L : from - 30000L).to(to == null ? -1L : to + 30000L).build();
            try {
                List subscriptions = this.subscriptionRepository.search(criteriaBuilder, new SortableBuilder().field("updatedAt").order(Order.ASC).build());
                if (subscriptions != null && !subscriptions.isEmpty()) {
                    emitter.onNext((Object)subscriptions);
                }
                emitter.onComplete();
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        });
    }

    @Generated
    public SubscriptionFetcher(SubscriptionRepository subscriptionRepository) {
        this.subscriptionRepository = subscriptionRepository;
    }
}

