/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.repository.fetcher;

import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.search.ApiKeyCriteria;
import io.gravitee.repository.management.api.search.Order;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.repository.management.model.ApiKey;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import lombok.Generated;

public class ApiKeyFetcher {
    private final ApiKeyRepository apiKeyRepository;

    public Flowable<List<ApiKey>> fetchLatest(Long from, Long to) {
        return Flowable.generate(emitter -> {
            ApiKeyCriteria criteriaBuilder = ApiKeyCriteria.builder().includeRevoked(true).from(from == null ? -1L : from - 30000L).to(to == null ? -1L : to + 30000L).build();
            try {
                List apiKeys = this.apiKeyRepository.findByCriteria(criteriaBuilder, new SortableBuilder().field("updatedAt").order(Order.ASC).build());
                if (apiKeys != null && !apiKeys.isEmpty()) {
                    emitter.onNext((Object)apiKeys);
                }
                emitter.onComplete();
            }
            catch (Exception e) {
                emitter.onError((Throwable)e);
            }
        });
    }

    @Generated
    public ApiKeyFetcher(ApiKeyRepository apiKeyRepository) {
        this.apiKeyRepository = apiKeyRepository;
    }
}

