/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.kubernetes.synchronizer;

import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.kubernetes.KubernetesSynchronizer;
import io.gravitee.gateway.services.sync.process.kubernetes.fetcher.ConfigMapEventFetcher;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.AbstractApiSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.repository.management.model.Event;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesApiSynchronizer
extends AbstractApiSynchronizer
implements KubernetesSynchronizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesApiSynchronizer.class);
    private final ConfigMapEventFetcher configMapEventFetcher;

    public KubernetesApiSynchronizer(ConfigMapEventFetcher configMapEventFetcher, ApiManager apiManager, ApiMapper apiMapper, PlanAppender planAppender, SubscriptionAppender subscriptionAppender, ApiKeyAppender apiKeyAppender, DeployerFactory deployerFactory, ThreadPoolExecutor syncKubernetesExecutor, ThreadPoolExecutor syncDeployerExecutor) {
        super(apiManager, apiMapper, planAppender, subscriptionAppender, apiKeyAppender, deployerFactory, syncKubernetesExecutor, syncDeployerExecutor);
        this.configMapEventFetcher = configMapEventFetcher;
    }

    @Override
    public Completable synchronize() {
        return this.configMapEventFetcher.fetchLatest().compose(upstream -> this.processEvents(false, (Flowable<List<Event>>)upstream)).doOnNext(apiReactor -> log.debug("api {} synchronized from kubernetes", (Object)apiReactor.apiId())).ignoreElements();
    }

    @Override
    protected int bulkEvents() {
        return 1;
    }
}

