/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.kubernetes.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.services.sync.SyncConfiguration;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.kubernetes.KubernetesSyncManager;
import io.gravitee.gateway.services.sync.process.kubernetes.KubernetesSynchronizer;
import io.gravitee.gateway.services.sync.process.kubernetes.fetcher.ConfigMapEventFetcher;
import io.gravitee.gateway.services.sync.process.kubernetes.spring.KubernetesSyncCondition;
import io.gravitee.gateway.services.sync.process.kubernetes.synchronizer.KubernetesApiSynchronizer;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={KubernetesSyncCondition.class})
public class KubernetesSyncConfiguration {
    @Bean(value={"syncKubernetesExecutor"})
    public ThreadPoolExecutor syncKubernetesExecutor(@Value(value="${services.sync.kubernetes.threads:-1}") int syncKubernetes) {
        int poolSize = syncKubernetes != -1 ? syncKubernetes : SyncConfiguration.POOL_SIZE;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, poolSize, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), SyncConfiguration.newThreadFactory("gio.sync-kubernetes-"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    @Bean
    public ConfigMapEventFetcher configMapEventFetcher(KubernetesClient kubernetesClient, @Value(value="${services.sync.kubernetes.namespaces:#{null}}") String[] namespaces, ObjectMapper objectMapper) {
        return new ConfigMapEventFetcher(kubernetesClient, namespaces, objectMapper);
    }

    @Bean
    public KubernetesApiSynchronizer kubernetesApiSynchronizer(ConfigMapEventFetcher configMapEventFetcher, ApiManager apiManager, ApiMapper apiMapper, PlanAppender planAppender, SubscriptionAppender subscriptionAppender, ApiKeyAppender apiKeyAppender, DeployerFactory deployerFactory, @Qualifier(value="syncKubernetesExecutor") ThreadPoolExecutor syncKubernetesExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new KubernetesApiSynchronizer(configMapEventFetcher, apiManager, apiMapper, planAppender, subscriptionAppender, apiKeyAppender, deployerFactory, syncKubernetesExecutor, syncDeployerExecutor);
    }

    @Bean
    public KubernetesSyncManager kubernetesSyncManager(List<KubernetesSynchronizer> kubernetesSynchronizers, DistributedSyncService distributedSyncService) {
        return new KubernetesSyncManager(kubernetesSynchronizers, distributedSyncService);
    }
}

