/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.kubernetes.fetcher;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.LabelSelector;
import io.gravitee.kubernetes.client.api.WatchQuery;
import io.gravitee.kubernetes.client.config.KubernetesConfig;
import io.gravitee.kubernetes.client.model.v1.ConfigMap;
import io.gravitee.kubernetes.client.model.v1.OwnerReference;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.LifecycleState;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapEventFetcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigMapEventFetcher.class);
    private static final String LABEL_MANAGED_BY = "managed-by";
    private static final String LABEL_GIO_TYPE = "gio-type";
    protected static final String GRAVITEE_IO = "gravitee.io";
    protected static final String API_DEFINITION_V1_ALPHA1 = "v1alpha1";
    protected static final String APIDEFINITIONS_TYPE = "apidefinitions.gravitee.io";
    protected static final String DATA_ENVIRONMENT_ID = "environmentId";
    protected static final String DATA_DEFINITION = "definition";
    private static final int RETRY_DELAY_MILLIS = 10000;
    private final KubernetesClient client;
    private final String[] namespaces;
    private final ObjectMapper objectMapper;

    public int bulkEvents() {
        return 1;
    }

    public Flowable<List<Event>> fetchLatest() {
        return this.watchConfigMaps().flatMapMaybe(this::convertTo).buffer(this.bulkEvents());
    }

    private Flowable<io.gravitee.kubernetes.client.model.v1.Event<ConfigMap>> watchConfigMaps() {
        List<String> namespacesAsList = this.getNamespacesAsList();
        if (namespacesAsList.contains("ALL")) {
            return this.watchConfigMaps(null);
        }
        return Flowable.fromIterable(namespacesAsList).flatMap(this::watchConfigMaps);
    }

    private Flowable<io.gravitee.kubernetes.client.model.v1.Event<ConfigMap>> watchConfigMaps(String namespace) {
        return this.client.watch(WatchQuery.configMaps().namespace(namespace).labelSelector(LabelSelector.equals((String)LABEL_MANAGED_BY, (String)GRAVITEE_IO)).labelSelector(LabelSelector.equals((String)LABEL_GIO_TYPE, (String)APIDEFINITIONS_TYPE)).build()).retryWhen(errors -> errors.delay(10000L, TimeUnit.MILLISECONDS));
    }

    public Maybe<Event> convertTo(io.gravitee.kubernetes.client.model.v1.Event<ConfigMap> configMapEvent) {
        ConfigMap configMap = (ConfigMap)configMapEvent.getObject();
        try {
            String definition = (String)configMap.getData().get(DATA_DEFINITION);
            if (definition != null && configMap.getMetadata().getOwnerReferences() != null) {
                DefinitionVersion definitionVersion;
                String apiId;
                Optional<OwnerReference> graviteeOwnerReference = configMap.getMetadata().getOwnerReferences().stream().filter(ownerReference -> ownerReference.getApiVersion().startsWith(GRAVITEE_IO)).findFirst();
                if (graviteeOwnerReference.isPresent()) {
                    OwnerReference ownerReference2 = graviteeOwnerReference.get();
                    if (ownerReference2.getApiVersion().endsWith(API_DEFINITION_V1_ALPHA1)) {
                        apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(definition, io.gravitee.definition.model.Api.class);
                        apiId = apiDefinition.getId();
                        definitionVersion = apiDefinition.getDefinitionVersion();
                    } else {
                        apiDefinition = (Api)this.objectMapper.readValue(definition, Api.class);
                        apiId = apiDefinition.getId();
                        definitionVersion = apiDefinition.getDefinitionVersion();
                    }
                } else {
                    throw new RuntimeException("GraviteeOwnerReference is missing for this configmap. Unable to process this event");
                }
                Event event = new Event();
                event.setProperties(Collections.singletonMap(Event.EventProperties.API_ID.getValue(), apiId));
                event.setCreatedAt(new Date());
                io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
                api.setEnvironmentId((String)configMap.getData().get(DATA_ENVIRONMENT_ID));
                api.setDefinition(definition);
                api.setDefinitionVersion(definitionVersion);
                api.setId(apiId);
                switch (configMapEvent.getType()) {
                    case "ADDED": 
                    case "MODIFIED": {
                        event.setType(EventType.PUBLISH_API);
                        api.setLifecycleState(LifecycleState.STARTED);
                        break;
                    }
                    case "DELETED": {
                        event.setType(EventType.UNPUBLISH_API);
                        api.setLifecycleState(LifecycleState.STOPPED);
                        break;
                    }
                    default: {
                        log.error("Unsupported configMap event type {}.", (Object)configMapEvent.getType());
                    }
                }
                event.setPayload(this.objectMapper.writeValueAsString((Object)api));
                return Maybe.just((Object)event);
            }
        }
        catch (Exception ex) {
            log.error("Unable to extract api definition from config map.", (Throwable)ex);
        }
        return Maybe.empty();
    }

    private List<String> getNamespacesAsList() {
        if (this.namespaces == null || this.namespaces.length == 0) {
            return List.of(KubernetesConfig.getInstance().getCurrentNamespace());
        }
        return Arrays.asList(this.namespaces);
    }

    @Generated
    public ConfigMapEventFetcher(KubernetesClient client, String[] namespaces, ObjectMapper objectMapper) {
        this.client = client;
        this.namespaces = namespaces;
        this.objectMapper = objectMapper;
    }
}

