/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.kubernetes;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.services.sync.SyncManager;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.kubernetes.KubernetesSynchronizer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSyncManager
extends AbstractService<SyncManager>
implements SyncManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesSyncManager.class);
    private final List<KubernetesSynchronizer> synchronizers;
    private final DistributedSyncService distributedSyncService;
    private Disposable watcherDisposable;

    protected void doStart() {
        log.debug("Starting kubernetes synchronization process");
        if (!this.distributedSyncService.isEnabled() || this.distributedSyncService.isPrimaryNode()) {
            this.watcherDisposable = Flowable.fromIterable(this.synchronizers).concatMapCompletable(KubernetesSynchronizer::synchronize).doOnError(throwable -> log.error("An error occurred during kubernetes synchronization refresh. Restarting.", throwable)).retry().subscribe();
        } else {
            log.warn("Kubernetes synchronization is disabled as distributed sync is enabled, and current node is secondary.");
        }
    }

    protected void doStop() {
        if (this.watcherDisposable != null && !this.watcherDisposable.isDisposed()) {
            this.watcherDisposable.dispose();
        }
    }

    @Override
    public boolean syncDone() {
        return true;
    }

    @Generated
    public KubernetesSyncManager(List<KubernetesSynchronizer> synchronizers, DistributedSyncService distributedSyncService) {
        this.synchronizers = synchronizers;
        this.distributedSyncService = distributedSyncService;
    }
}

