/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.distributed.fetcher.DistributedEventFetcher;
import io.gravitee.gateway.services.sync.process.distributed.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.DictionaryMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.OrganizationMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.distributed.service.DefaultDistributedSyncService;
import io.gravitee.gateway.services.sync.process.distributed.spring.DistributedSyncEnabledCondition;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.api.DistributedApiSynchronizer;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.apikey.DistributedApiKeySynchronizer;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.dictionary.DistributedDictionarySynchronizer;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.organization.DistributedOrganizationSynchronizer;
import io.gravitee.gateway.services.sync.process.distributed.synchronizer.subscription.DistributedSubscriptionSynchronizer;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.repository.distributedsync.api.DistributedEventRepository;
import io.gravitee.repository.distributedsync.api.DistributedSyncStateRepository;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@Conditional(value={DistributedSyncEnabledCondition.class})
public class DistributedSyncConfiguration {
    @Bean
    public ApiMapper distributedApiMapper(ObjectMapper objectMapper, SubscriptionMapper subscriptionMapper, ApiKeyMapper apiKeyMapper) {
        return new ApiMapper(objectMapper, subscriptionMapper, apiKeyMapper);
    }

    @Bean
    public ApiKeyMapper distributedApiKeyMapper(ObjectMapper objectMapper) {
        return new ApiKeyMapper(objectMapper);
    }

    @Bean
    public SubscriptionMapper distributedSubscriptionMapper(ObjectMapper objectMapper) {
        return new SubscriptionMapper(objectMapper);
    }

    @Bean
    public DictionaryMapper distributedDictionaryMapper(ObjectMapper objectMapper) {
        return new DictionaryMapper(objectMapper);
    }

    @Bean
    public OrganizationMapper distributedOrganizationMapper(ObjectMapper objectMapper) {
        return new OrganizationMapper(objectMapper);
    }

    @Bean
    public DistributedEventFetcher distributedEventFetcher(@Lazy DistributedEventRepository distributedEventRepository, @Value(value="${services.sync.bulk_items:100}") int bulkItems) {
        return new DistributedEventFetcher(distributedEventRepository, bulkItems);
    }

    @Bean
    public DistributedSubscriptionSynchronizer distributedSubscriptionSynchronizer(DistributedEventFetcher distributedEventFetcher, SubscriptionMapper subscriptionMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DistributedSubscriptionSynchronizer(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor, deployerFactory, subscriptionMapper);
    }

    @Bean
    public DistributedApiKeySynchronizer distributedApiKeySynchronizer(DistributedEventFetcher distributedEventFetcher, ApiKeyMapper apiKeyMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DistributedApiKeySynchronizer(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor, deployerFactory, apiKeyMapper);
    }

    @Bean
    public DistributedApiSynchronizer distributedApiSynchronizer(DistributedEventFetcher distributedEventFetcher, ApiMapper apiMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DistributedApiSynchronizer(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor, deployerFactory, apiMapper);
    }

    @Bean
    public DistributedDictionarySynchronizer dictionarySynchronizer(DistributedEventFetcher distributedEventFetcher, DictionaryMapper dictionaryMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DistributedDictionarySynchronizer(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor, deployerFactory, dictionaryMapper);
    }

    @Bean
    public DistributedOrganizationSynchronizer organizationSynchronizer(DistributedEventFetcher distributedEventFetcher, OrganizationMapper organizationMapper, DeployerFactory deployerFactory, @Qualifier(value="syncFetcherExecutor") ThreadPoolExecutor syncFetcherExecutor, @Qualifier(value="syncDeployerExecutor") ThreadPoolExecutor syncDeployerExecutor) {
        return new DistributedOrganizationSynchronizer(distributedEventFetcher, syncFetcherExecutor, syncDeployerExecutor, deployerFactory, organizationMapper);
    }

    @Bean
    public DefaultDistributedSyncService distributedSyncService(Node node, ClusterManager clusterManager, @Value(value="${distributed-sync.type}") String distributedSyncRepoType, @Lazy DistributedEventRepository distributedEventRepository, @Lazy DistributedSyncStateRepository distributedSyncStateRepository, ApiMapper apiMapper, SubscriptionMapper subscriptionMapper, ApiKeyMapper apiKeyMapper, OrganizationMapper organizationMapper, DictionaryMapper dictionaryMapper) {
        return new DefaultDistributedSyncService(node, clusterManager, distributedSyncRepoType, distributedEventRepository, distributedSyncStateRepository, apiMapper, subscriptionMapper, apiKeyMapper, organizationMapper, dictionaryMapper);
    }
}

