/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.service;

import io.gravitee.common.util.Version;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.distributed.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.DictionaryMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.OrganizationMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.distributed.model.DistributedSyncException;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey.SingleApiKeyDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary.DictionaryDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription.SingleSubscriptionDeployable;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.cluster.ClusterManager;
import io.gravitee.repository.distributedsync.api.DistributedEventRepository;
import io.gravitee.repository.distributedsync.api.DistributedSyncStateRepository;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.gravitee.repository.distributedsync.model.DistributedSyncAction;
import io.gravitee.repository.distributedsync.model.DistributedSyncState;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;

public class DefaultDistributedSyncService
implements DistributedSyncService {
    private final Node node;
    private final ClusterManager clusterManager;
    private final String distributedSyncRepoType;
    private final DistributedEventRepository distributedEventRepository;
    private final DistributedSyncStateRepository distributedSyncStateRepository;
    private final ApiMapper apiMapper;
    private final SubscriptionMapper subscriptionMapper;
    private final ApiKeyMapper apiKeyMapper;
    private final OrganizationMapper organizationMapper;
    private final DictionaryMapper dictionaryMapper;

    @Override
    public void validate() {
        if (this.distributedSyncRepoType == null || this.distributedSyncRepoType.isEmpty()) {
            throw new SyncException("Distributed sync configuration invalid. No repository configured, check 'distributed-sync.type' value.");
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isPrimaryNode() {
        return this.clusterManager.self().primary();
    }

    @Override
    public Completable ready() {
        return this.distributedSyncStateRepository.ready().onErrorResumeNext(throwable -> Completable.error((Throwable)new DistributedSyncException("Distributed Sync repository is not ready.")));
    }

    @Override
    public Maybe<DistributedSyncState> state() {
        return Maybe.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.distributedSyncStateRepository.findByClusterId(this.clusterManager.clusterId());
            }
            return Maybe.empty();
        });
    }

    @Override
    public Completable storeState(long fromTime, long toTime) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.distributedSyncStateRepository.createOrUpdate(DistributedSyncState.builder().clusterId(this.clusterManager.clusterId()).nodeId(this.node.id()).nodeVersion(Version.RUNTIME_VERSION.toString()).from(Long.valueOf(fromTime)).to(Long.valueOf(toTime)).build());
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable distributeIfNeeded(ApiReactorDeployable deployable) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.apiMapper.to(deployable).flatMapCompletable(arg_0 -> ((DistributedEventRepository)this.distributedEventRepository).createOrUpdate(arg_0)).andThen((CompletableSource)Completable.defer(() -> {
                    if (deployable.syncAction() == SyncAction.UNDEPLOY) {
                        return this.distributedEventRepository.updateAll(DistributedEventType.API, deployable.apiId(), DistributedSyncAction.UNDEPLOY, new Date());
                    }
                    return Completable.complete();
                }));
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable distributeIfNeeded(SingleSubscriptionDeployable deployable) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.subscriptionMapper.to(deployable).flatMapCompletable(arg_0 -> ((DistributedEventRepository)this.distributedEventRepository).createOrUpdate(arg_0));
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable distributeIfNeeded(SingleApiKeyDeployable deployable) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.apiKeyMapper.to(deployable).flatMapCompletable(arg_0 -> ((DistributedEventRepository)this.distributedEventRepository).createOrUpdate(arg_0));
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable distributeIfNeeded(OrganizationDeployable deployable) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.organizationMapper.to(deployable).flatMapCompletable(arg_0 -> ((DistributedEventRepository)this.distributedEventRepository).createOrUpdate(arg_0));
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable distributeIfNeeded(DictionaryDeployable deployable) {
        return Completable.defer(() -> {
            if (this.isPrimaryNode()) {
                return this.dictionaryMapper.to(deployable).flatMapCompletable(arg_0 -> ((DistributedEventRepository)this.distributedEventRepository).createOrUpdate(arg_0));
            }
            return Completable.complete();
        });
    }

    @Generated
    public DefaultDistributedSyncService(Node node, ClusterManager clusterManager, String distributedSyncRepoType, DistributedEventRepository distributedEventRepository, DistributedSyncStateRepository distributedSyncStateRepository, ApiMapper apiMapper, SubscriptionMapper subscriptionMapper, ApiKeyMapper apiKeyMapper, OrganizationMapper organizationMapper, DictionaryMapper dictionaryMapper) {
        this.node = node;
        this.clusterManager = clusterManager;
        this.distributedSyncRepoType = distributedSyncRepoType;
        this.distributedEventRepository = distributedEventRepository;
        this.distributedSyncStateRepository = distributedSyncStateRepository;
        this.apiMapper = apiMapper;
        this.subscriptionMapper = subscriptionMapper;
        this.apiKeyMapper = apiKeyMapper;
        this.organizationMapper = organizationMapper;
        this.dictionaryMapper = dictionaryMapper;
    }
}

