/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.dictionary.model.Dictionary;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SyncActionMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary.DictionaryDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryMapper.class);
    private final ObjectMapper objectMapper;

    public Maybe<DictionaryDeployable> to(DistributedEvent event) {
        return Maybe.fromCallable(() -> {
            try {
                Dictionary dictionary = (Dictionary)this.objectMapper.readValue(event.getPayload(), Dictionary.class);
                return DictionaryDeployable.builder().id(dictionary.getId()).dictionary(dictionary).syncAction(SyncActionMapper.to(event.getSyncAction())).build();
            }
            catch (Exception e) {
                log.warn("Error while determining dictionary into event payload", (Throwable)e);
                return null;
            }
        });
    }

    public Maybe<DistributedEvent> to(DictionaryDeployable deployable) {
        return Maybe.fromCallable(() -> {
            try {
                DistributedEvent.DistributedEventBuilder builder = DistributedEvent.builder().id(deployable.id()).type(DistributedEventType.DICTIONARY).syncAction(SyncActionMapper.to(deployable.syncAction())).updatedAt(new Date());
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    builder.payload(this.objectMapper.writeValueAsString((Object)deployable.dictionary()));
                }
                return builder.build();
            }
            catch (Exception e) {
                log.warn("Error while building distributed event from dictionary", (Throwable)e);
                return null;
            }
        });
    }

    @Generated
    public DictionaryMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

