/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.distributed.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SyncActionMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiMapper.class);
    private final ObjectMapper objectMapper;
    private final SubscriptionMapper subscriptionMapper;
    private final ApiKeyMapper apiKeyMapper;

    public Maybe<ApiReactorDeployable> to(DistributedEvent event) {
        return Maybe.fromCallable(() -> {
            try {
                ReactableApi<?> reactableApi = this.toReactable(event.getPayload());
                return ApiReactorDeployable.builder().apiId(event.getId()).reactableApi(reactableApi).syncAction(SyncActionMapper.to(event.getSyncAction())).build();
            }
            catch (Exception e) {
                log.warn("Error while determining api into event payload", (Throwable)e);
                return null;
            }
        });
    }

    private ReactableApi<?> toReactable(String payload) throws JsonProcessingException {
        ReactableApi reactableApi = null;
        if (payload != null && !payload.isBlank()) {
            try {
                reactableApi = (ReactableApi)this.objectMapper.readValue(payload, io.gravitee.gateway.reactive.handlers.api.v4.Api.class);
            }
            catch (Exception e) {
                reactableApi = (ReactableApi)this.objectMapper.readValue(payload, Api.class);
            }
        }
        return reactableApi;
    }

    public Flowable<DistributedEvent> to(ApiReactorDeployable deployable) {
        return Flowable.concatArray((Publisher[])new Publisher[]{this.toApiDistributedEvent(deployable), this.subscriptionMapper.to(deployable), this.apiKeyMapper.to(deployable)});
    }

    private Flowable<DistributedEvent> toApiDistributedEvent(ApiReactorDeployable deployable) {
        return Flowable.fromCallable(() -> {
            try {
                DistributedEvent.DistributedEventBuilder builder = DistributedEvent.builder().id(deployable.id()).type(DistributedEventType.API).syncAction(SyncActionMapper.to(deployable.syncAction())).updatedAt(new Date());
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    builder.payload(this.objectMapper.writeValueAsString(deployable.reactableApi()));
                }
                return builder.build();
            }
            catch (Exception e) {
                log.warn("Error while building distributed event from api reactor", (Throwable)e);
                return null;
            }
        });
    }

    @Generated
    public ApiMapper(ObjectMapper objectMapper, SubscriptionMapper subscriptionMapper, ApiKeyMapper apiKeyMapper) {
        this.objectMapper = objectMapper;
        this.subscriptionMapper = subscriptionMapper;
        this.apiKeyMapper = apiKeyMapper;
    }
}

