/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.api.service.ApiKey;
import io.gravitee.gateway.services.sync.process.common.model.ApiKeyDeployable;
import io.gravitee.gateway.services.sync.process.common.model.SyncAction;
import io.gravitee.gateway.services.sync.process.distributed.mapper.SyncActionMapper;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey.SingleApiKeyDeployable;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeyMapper.class);
    private final ObjectMapper objectMapper;

    public Maybe<SingleApiKeyDeployable> to(DistributedEvent event) {
        return Maybe.fromCallable(() -> {
            try {
                ApiKey apiKey = (ApiKey)this.objectMapper.readValue(event.getPayload(), ApiKey.class);
                return SingleApiKeyDeployable.builder().apiKey(apiKey).syncAction(SyncActionMapper.to(event.getSyncAction())).build();
            }
            catch (Exception e) {
                log.warn("Error while determining apikey into event payload", (Throwable)e);
                return null;
            }
        });
    }

    public Flowable<DistributedEvent> to(ApiKeyDeployable deployable) {
        return Flowable.fromIterable(deployable.apiKeys()).flatMapMaybe(apiKey -> Maybe.fromCallable(() -> {
            try {
                DistributedEvent.DistributedEventBuilder builder = DistributedEvent.builder().id(apiKey.getId()).type(DistributedEventType.API_KEY).syncAction(SyncActionMapper.to(deployable.syncAction())).updatedAt(new Date()).refType(DistributedEventType.API).refId(deployable.apiId());
                if (deployable.syncAction() == SyncAction.DEPLOY) {
                    builder.payload(this.objectMapper.writeValueAsString(apiKey));
                }
                return builder.build();
            }
            catch (Exception e) {
                log.warn("Error while building distributed event from apikey", (Throwable)e);
                return null;
            }
        }));
    }

    @Generated
    public ApiKeyMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

