/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.distributed.fetcher;

import io.gravitee.repository.distributedsync.api.DistributedEventRepository;
import io.gravitee.repository.distributedsync.api.search.DistributedEventCriteria;
import io.gravitee.repository.distributedsync.model.DistributedEvent;
import io.gravitee.repository.distributedsync.model.DistributedEventType;
import io.gravitee.repository.distributedsync.model.DistributedSyncAction;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.reactivestreams.Publisher;

public class DistributedEventFetcher {
    private final DistributedEventRepository distributedEventRepository;
    private final int bulkItems;

    public Flowable<DistributedEvent> fetchLatest(Long from, Long to, DistributedEventType type, Set<DistributedSyncAction> syncActions) {
        AtomicBoolean lastPage = new AtomicBoolean();
        AtomicLong page = new AtomicLong(0L);
        DistributedEventCriteria distributedEventCriteria = DistributedEventCriteria.builder().from(from == null ? -1L : from - 30000L).to(to == null ? -1L : to + 30000L).type(type).syncActions(syncActions).build();
        return Flowable.just((Object)page).map(AtomicLong::getAndIncrement).flatMap(nextPage -> this.distributedEventRepository.search(distributedEventCriteria, nextPage, Long.valueOf(this.bulkItems))).switchIfEmpty((Publisher)Flowable.fromAction(() -> lastPage.set(true))).repeatUntil(lastPage::get);
    }

    @Generated
    public DistributedEventFetcher(DistributedEventRepository distributedEventRepository, int bulkItems) {
        this.distributedEventRepository = distributedEventRepository;
        this.bulkItems = bulkItems;
    }

    @Generated
    public int bulkItems() {
        return this.bulkItems;
    }
}

