/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.utils.UUID;
import io.gravitee.definition.model.command.SubscriptionFailureCommand;
import io.gravitee.gateway.api.service.Subscription;
import io.gravitee.gateway.api.service.SubscriptionService;
import io.gravitee.gateway.reactive.reactor.v4.subscription.SubscriptionDispatcher;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.SubscriptionDeployable;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.subscription.SingleSubscriptionDeployable;
import io.gravitee.node.api.Node;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.CommandTags;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.model.Command;
import io.gravitee.repository.management.model.MessageRecipient;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionDeployer
implements Deployer<SubscriptionDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionDeployer.class);
    private final SubscriptionService subscriptionService;
    private final SubscriptionDispatcher subscriptionDispatcher;
    private final CommandRepository commandRepository;
    private final Node node;
    private final ObjectMapper objectMapper;
    private final DistributedSyncService distributedSyncService;
    private final Map<String, List<Subscription>> dispatchableSubscription = new ConcurrentHashMap<String, List<Subscription>>();

    @Override
    public Completable deploy(SubscriptionDeployable deployable) {
        return Completable.fromRunnable(() -> {
            if (deployable.subscriptions() != null) {
                deployable.subscriptions().stream().filter(subscription -> deployable.subscribablePlans().contains(subscription.getPlan())).forEach(subscription -> {
                    try {
                        if (Subscription.Type.PUSH == subscription.getType()) {
                            this.dispatchableSubscription.compute(subscription.getApi(), (apiId, subscriptions) -> {
                                if (subscriptions == null) {
                                    subscriptions = new ArrayList<Subscription>();
                                }
                                subscriptions.add(subscription);
                                return subscriptions;
                            });
                        }
                        this.subscriptionService.register(subscription);
                        log.debug("Subscription [{}] deployed for api [{}] ", (Object)subscription.getId(), (Object)subscription.getApi());
                    }
                    catch (Exception e) {
                        log.warn("An error occurred when trying to deploy subscription [{}].", (Object)subscription.getId(), (Object)e);
                    }
                });
            }
        });
    }

    @Override
    public Completable doAfterDeployment(SubscriptionDeployable deployable) {
        return Completable.defer(() -> {
            List<Subscription> subscriptions = this.dispatchableSubscription.remove(deployable.apiId());
            if (subscriptions != null) {
                subscriptions.forEach(s -> this.dispatchSubscription((Subscription)s).subscribe());
            }
            return this.distributeIfNeeded(deployable);
        });
    }

    @Override
    public Completable undeploy(SubscriptionDeployable deployable) {
        return Completable.defer(() -> {
            if (deployable instanceof ApiReactorDeployable) {
                return this.undeployForApi((ApiReactorDeployable)deployable);
            }
            if (deployable instanceof SingleSubscriptionDeployable) {
                return this.undeploySingleSubscription((SingleSubscriptionDeployable)deployable);
            }
            return Completable.complete();
        });
    }

    @Override
    public Completable doAfterUndeployment(SubscriptionDeployable deployable) {
        return this.distributeIfNeeded(deployable);
    }

    private Completable distributeIfNeeded(SubscriptionDeployable deployable) {
        return Completable.defer(() -> {
            if (deployable instanceof SingleSubscriptionDeployable) {
                SingleSubscriptionDeployable singleSubscriptionDeployable = (SingleSubscriptionDeployable)deployable;
                return this.distributedSyncService.distributeIfNeeded(singleSubscriptionDeployable);
            }
            return Completable.complete();
        });
    }

    private Completable undeployForApi(ApiReactorDeployable apiReactorDeployable) {
        try {
            this.subscriptionService.unregisterByApiId(apiReactorDeployable.apiId());
            log.debug("Subscriptions undeployed for api [{}] ", (Object)apiReactorDeployable.apiId());
        }
        catch (Exception e) {
            log.warn("An error occurred when trying to undeploy subscriptions from api [{}].", (Object)apiReactorDeployable.apiId(), (Object)e);
        }
        return Completable.complete();
    }

    private Completable undeploySingleSubscription(SingleSubscriptionDeployable subscriptionDeployable) {
        try {
            Subscription subscription = subscriptionDeployable.subscription();
            this.subscriptionService.unregister(subscription);
            log.debug("Subscription [{}] undeployed for api [{}] ", (Object)subscriptionDeployable.id(), (Object)subscriptionDeployable.apiId());
            if (Subscription.Type.PUSH == subscription.getType()) {
                return this.dispatchSubscription(subscription);
            }
        }
        catch (Exception e) {
            log.warn("An error occurred when trying to undeploy subscriptions [{}].", (Object)subscriptionDeployable.id(), (Object)e);
        }
        return Completable.complete();
    }

    private Completable dispatchSubscription(Subscription subscription) {
        return this.subscriptionDispatcher.dispatch(subscription).doOnComplete(() -> log.debug("Subscription [{}] has been dispatched", (Object)subscription.getId())).onErrorResumeNext(t -> {
            log.error("Subscription [{}] failed", (Object)subscription.getId(), t);
            return this.sendFailureCommand(subscription, (Throwable)t).onErrorComplete();
        });
    }

    private Completable sendFailureCommand(Subscription subscription, Throwable throwable) {
        return Completable.fromRunnable(() -> {
            Command command = new Command();
            Instant now = Instant.now();
            command.setId(UUID.random().toString());
            command.setFrom(this.node.id());
            command.setTo(MessageRecipient.MANAGEMENT_APIS.name());
            command.setTags(List.of(CommandTags.SUBSCRIPTION_FAILURE.name()));
            command.setCreatedAt(Date.from(now));
            command.setUpdatedAt(Date.from(now));
            this.convertSubscriptionCommand(subscription, command, throwable.getMessage());
            this.saveCommand(subscription, command);
        }).subscribeOn(Schedulers.io());
    }

    private void convertSubscriptionCommand(Subscription subscription, Command command, String errorMessage) {
        try {
            command.setContent(this.objectMapper.writeValueAsString((Object)new SubscriptionFailureCommand(subscription.getId(), errorMessage)));
        }
        catch (JsonProcessingException e) {
            log.error("Failed to convert subscription command [{}] to string", (Object)subscription.getId(), (Object)e);
            JsonObject json = new JsonObject();
            json.put("subscriptionId", (Object)subscription.getId()).put("failureCause", (Object)errorMessage);
            command.setContent(json.encode());
        }
    }

    private void saveCommand(Subscription subscription, Command command) {
        try {
            this.commandRepository.create((Object)command);
        }
        catch (TechnicalException e) {
            log.error("Failed to create subscription command [{}]", (Object)subscription.getId(), (Object)e);
        }
    }

    @Generated
    public SubscriptionDeployer(SubscriptionService subscriptionService, SubscriptionDispatcher subscriptionDispatcher, CommandRepository commandRepository, Node node, ObjectMapper objectMapper, DistributedSyncService distributedSyncService) {
        this.subscriptionService = subscriptionService;
        this.subscriptionDispatcher = subscriptionDispatcher;
        this.commandRepository = commandRepository;
        this.node = node;
        this.objectMapper = objectMapper;
        this.distributedSyncService = distributedSyncService;
    }
}

