/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import io.gravitee.gateway.platform.organization.ReactableOrganization;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.organization.OrganizationDeployable;
import io.reactivex.rxjava3.core.Completable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationDeployer
implements Deployer<OrganizationDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationDeployer.class);
    private final OrganizationManager organizationManager;
    private final DistributedSyncService distributedSyncService;

    @Override
    public Completable deploy(OrganizationDeployable deployable) {
        return Completable.fromRunnable(() -> {
            ReactableOrganization reactableOrganization = deployable.reactableOrganization();
            try {
                this.organizationManager.register(reactableOrganization);
                log.debug("Organization [{}] deployed ", (Object)deployable.id());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to deploy organization %s [%s].", reactableOrganization.getName(), reactableOrganization.getId()), e);
            }
        });
    }

    @Override
    public Completable doAfterDeployment(OrganizationDeployable deployable) {
        return this.distributedSyncService.distributeIfNeeded(deployable);
    }

    @Generated
    public OrganizationDeployer(OrganizationManager organizationManager, DistributedSyncService distributedSyncService) {
        this.organizationManager = organizationManager;
        this.distributedSyncService = distributedSyncService;
    }
}

