/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import io.gravitee.gateway.dictionary.DictionaryManager;
import io.gravitee.gateway.dictionary.model.Dictionary;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.dictionary.DictionaryDeployable;
import io.reactivex.rxjava3.core.Completable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryDeployer
implements Deployer<DictionaryDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictionaryDeployer.class);
    private final DictionaryManager dictionaryManager;
    private final DistributedSyncService distributedSyncService;

    @Override
    public Completable deploy(DictionaryDeployable deployable) {
        return Completable.fromRunnable(() -> {
            Dictionary dictionary = deployable.dictionary();
            try {
                this.dictionaryManager.deploy(dictionary);
                log.debug("Dictionary [{}] deployed ", (Object)deployable.id());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to deploy dictionary %s [%s].", dictionary.getName(), dictionary.getId()), e);
            }
        });
    }

    @Override
    public Completable doAfterDeployment(DictionaryDeployable deployable) {
        return this.distributedSyncService.distributeIfNeeded(deployable);
    }

    @Override
    public Completable undeploy(DictionaryDeployable deployable) {
        return Completable.fromRunnable(() -> {
            try {
                this.dictionaryManager.undeploy(deployable.id());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to undeploy dictionary [%s].", deployable.id()), e);
            }
        });
    }

    @Override
    public Completable doAfterUndeployment(DictionaryDeployable deployable) {
        return this.distributedSyncService.distributeIfNeeded(deployable);
    }

    @Generated
    public DictionaryDeployer(DictionaryManager dictionaryManager, DistributedSyncService distributedSyncService) {
        this.dictionaryManager = dictionaryManager;
        this.distributedSyncService = distributedSyncService;
    }
}

