/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import io.gravitee.common.event.EventManager;
import io.gravitee.gateway.reactor.ReactorEvent;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.debug.DebugDeployable;
import io.reactivex.rxjava3.core.Completable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDeployer
implements Deployer<DebugDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugDeployer.class);
    private final EventManager eventManager;

    @Override
    public Completable deploy(DebugDeployable deployable) {
        return Completable.fromRunnable(() -> {
            try {
                this.eventManager.publishEvent((Enum)ReactorEvent.DEBUG, (Object)deployable.reactable());
                log.debug("Debug event sent [{}]", (Object)deployable.id());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to deploy debug reactable [%s].", deployable.id()), e);
            }
        });
    }

    @Generated
    public DebugDeployer(EventManager eventManager) {
        this.eventManager = eventManager;
    }
}

