/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import io.gravitee.gateway.api.service.ApiKeyService;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.ApiKeyDeployable;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.apikey.SingleApiKeyDeployable;
import io.reactivex.rxjava3.core.Completable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiKeyDeployer
implements Deployer<ApiKeyDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiKeyDeployer.class);
    private final ApiKeyService apiKeyService;
    private final DistributedSyncService distributedSyncService;

    @Override
    public Completable deploy(ApiKeyDeployable deployable) {
        return Completable.fromRunnable(() -> {
            if (deployable.apiKeys() != null) {
                deployable.apiKeys().forEach(apiKey -> {
                    try {
                        this.apiKeyService.register(apiKey);
                        log.debug("ApiKey [{}] of subscription [{}] deployed for api [{}] ", new Object[]{apiKey.getId(), apiKey.getSubscription(), apiKey.getApi()});
                    }
                    catch (Exception e) {
                        log.warn("An error occurred when trying to deploy ApiKey [{}].", (Object)apiKey.getId(), (Object)e);
                    }
                });
            }
        });
    }

    @Override
    public Completable doAfterDeployment(ApiKeyDeployable deployable) {
        return this.distributeIfNeeded(deployable);
    }

    @Override
    public Completable undeploy(ApiKeyDeployable deployable) {
        return Completable.fromRunnable(() -> {
            if (deployable instanceof ApiReactorDeployable) {
                this.undeployApiReactor((ApiReactorDeployable)deployable);
            } else if (deployable instanceof SingleApiKeyDeployable) {
                this.undeployApiKey((SingleApiKeyDeployable)deployable);
            }
        });
    }

    @Override
    public Completable doAfterUndeployment(ApiKeyDeployable deployable) {
        return this.distributeIfNeeded(deployable);
    }

    private Completable distributeIfNeeded(ApiKeyDeployable deployable) {
        return Completable.defer(() -> {
            if (deployable instanceof SingleApiKeyDeployable) {
                SingleApiKeyDeployable singleApiKeyDeployable = (SingleApiKeyDeployable)deployable;
                return this.distributedSyncService.distributeIfNeeded(singleApiKeyDeployable);
            }
            return Completable.complete();
        });
    }

    private void undeployApiReactor(ApiReactorDeployable apiReactorDeployable) {
        try {
            this.apiKeyService.unregisterByApiId(apiReactorDeployable.apiId());
            log.debug("ApiKeys undeployed for api [{}] ", (Object)apiReactorDeployable.apiId());
        }
        catch (Exception e) {
            log.warn("An error occurred when trying to undeploy apiKeys from api [{}].", (Object)apiReactorDeployable.apiId(), (Object)e);
        }
    }

    private void undeployApiKey(SingleApiKeyDeployable singleApikeyDeployable) {
        try {
            this.apiKeyService.unregister(singleApikeyDeployable.apiKey());
            log.debug("ApiKey [{}] undeployed for api [{}] ", (Object)singleApikeyDeployable.id(), (Object)singleApikeyDeployable.apiId());
        }
        catch (Exception e) {
            log.warn("An error occurred when trying to undeploy apiKey [{}].", (Object)singleApikeyDeployable.id(), (Object)e);
        }
    }

    @Generated
    public ApiKeyDeployer(ApiKeyService apiKeyService, DistributedSyncService distributedSyncService) {
        this.apiKeyService = apiKeyService;
        this.distributedSyncService = distributedSyncService;
    }
}

