/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync.process.common.deployer;

import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.reactor.ReactableApi;
import io.gravitee.gateway.services.sync.process.common.deployer.Deployer;
import io.gravitee.gateway.services.sync.process.common.model.SyncException;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.repository.service.PlanService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiReactorDeployable;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiDeployer
implements Deployer<ApiReactorDeployable> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiDeployer.class);
    private final ApiManager apiManager;
    private final PlanService planService;
    private final DistributedSyncService distributedSyncService;

    @Override
    public Completable deploy(ApiReactorDeployable deployable) {
        return Completable.fromRunnable(() -> {
            ReactableApi<?> reactableApi = deployable.reactableApi();
            try {
                this.apiManager.register(reactableApi);
                log.debug("Api [{}] deployed ", (Object)deployable.apiId());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to deploy api %s [%s].", reactableApi.getName(), reactableApi.getId()), e);
            }
        });
    }

    @Override
    public Completable doAfterDeployment(ApiReactorDeployable deployable) {
        return Completable.fromRunnable(() -> this.planService.register(deployable)).andThen((CompletableSource)this.distributedSyncService.distributeIfNeeded(deployable));
    }

    @Override
    public Completable undeploy(ApiReactorDeployable deployable) {
        return Completable.fromRunnable(() -> {
            try {
                this.planService.unregister(deployable);
                this.apiManager.unregister(deployable.apiId());
                log.debug("Api [{}] undeployed ", (Object)deployable.apiId());
            }
            catch (Exception e) {
                throw new SyncException(String.format("An error occurred when trying to undeploy api [%s].", deployable.apiId()), e);
            }
        });
    }

    @Override
    public Completable doAfterUndeployment(ApiReactorDeployable deployable) {
        return this.distributedSyncService.distributeIfNeeded(deployable);
    }

    @Generated
    public ApiDeployer(ApiManager apiManager, PlanService planService, DistributedSyncService distributedSyncService) {
        this.apiManager = apiManager;
        this.planService = planService;
        this.distributedSyncService = distributedSyncService;
    }
}

