/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.services.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.gateway.api.service.ApiKeyService;
import io.gravitee.gateway.api.service.SubscriptionService;
import io.gravitee.gateway.dictionary.DictionaryManager;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.handlers.api.manager.ApiManager;
import io.gravitee.gateway.platform.organization.manager.OrganizationManager;
import io.gravitee.gateway.reactive.reactor.v4.subscription.SubscriptionDispatcher;
import io.gravitee.gateway.services.sync.SyncManager;
import io.gravitee.gateway.services.sync.healthcheck.SyncProcessProbe;
import io.gravitee.gateway.services.sync.process.common.deployer.DeployerFactory;
import io.gravitee.gateway.services.sync.process.deployer.NoOpSubscriptionDispatcher;
import io.gravitee.gateway.services.sync.process.distributed.service.DistributedSyncService;
import io.gravitee.gateway.services.sync.process.distributed.service.NoopDistributedSyncService;
import io.gravitee.gateway.services.sync.process.distributed.spring.DistributedSyncDisabledCondition;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiKeyMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.ApiMapper;
import io.gravitee.gateway.services.sync.process.repository.mapper.SubscriptionMapper;
import io.gravitee.gateway.services.sync.process.repository.service.EnvironmentService;
import io.gravitee.gateway.services.sync.process.repository.service.PlanService;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.ApiKeyAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.PlanAppender;
import io.gravitee.gateway.services.sync.process.repository.synchronizer.api.SubscriptionAppender;
import io.gravitee.node.api.Node;
import io.gravitee.repository.management.api.ApiKeyRepository;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.reactivex.rxjava3.annotations.NonNull;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SyncConfiguration {
    public static final int POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_BULK_ITEMS = 100;

    @Bean(value={"syncFetcherExecutor"})
    public ThreadPoolExecutor syncFetcherExecutor(@Value(value="${services.sync.fetcher:-1}") int syncFetcher) {
        int poolSize = syncFetcher != -1 ? syncFetcher : POOL_SIZE;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, poolSize, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), SyncConfiguration.newThreadFactory("gio.sync-fetcher-"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        threadPoolExecutor.prestartCoreThread();
        return threadPoolExecutor;
    }

    @Bean(value={"syncDeployerExecutor"})
    public ThreadPoolExecutor syncDeployerExecutor(@Value(value="${services.sync.deployer:-1}") int syncDeployer) {
        int poolSize = syncDeployer != -1 ? syncDeployer : POOL_SIZE;
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, poolSize, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), SyncConfiguration.newThreadFactory("gio.sync-deployer-"));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        threadPoolExecutor.prestartCoreThread();
        return threadPoolExecutor;
    }

    public static ThreadFactory newThreadFactory(final String x) {
        return new ThreadFactory(){
            private int counter = 0;

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, x + this.counter++);
            }
        };
    }

    @Bean
    public ApiMapper apiMapper(ObjectMapper objectMapper, EnvironmentService environmentService) {
        return new ApiMapper(objectMapper, environmentService);
    }

    @Bean
    public SubscriptionMapper subscriptionMapper(ObjectMapper objectMapper) {
        return new SubscriptionMapper(objectMapper);
    }

    @Bean
    public ApiKeyMapper apiKeyMapper() {
        return new ApiKeyMapper();
    }

    @Bean
    public PlanService planService() {
        return new PlanService();
    }

    @Bean
    public EnvironmentService environmentEnhanceService(EnvironmentRepository environmentRepository, OrganizationRepository organizationRepository) {
        return new EnvironmentService(environmentRepository, organizationRepository);
    }

    @Bean
    public PlanAppender planAppender(ObjectMapper objectMapper, PlanRepository planRepository, GatewayConfiguration gatewayConfiguration) {
        return new PlanAppender(objectMapper, planRepository, gatewayConfiguration);
    }

    @Bean
    public SubscriptionAppender subscriptionAppender(SubscriptionRepository subscriptionRepository, SubscriptionMapper subscriptionMapper) {
        return new SubscriptionAppender(subscriptionRepository, subscriptionMapper);
    }

    @Bean
    public ApiKeyAppender apiKeyAppender(ApiKeyRepository apiKeyRepository, ApiKeyMapper apiKeyMapper) {
        return new ApiKeyAppender(apiKeyRepository, apiKeyMapper);
    }

    @Bean
    @Conditional(value={DistributedSyncDisabledCondition.class})
    public DistributedSyncService distributedSyncService() {
        return new NoopDistributedSyncService();
    }

    @Bean
    public DeployerFactory deployerFactory(ApiKeyService apiKeyService, SubscriptionService subscriptionService, PlanService planCache, @Lazy SubscriptionDispatcher subscriptionDispatcher, CommandRepository commandRepository, Node node, ObjectMapper objectMapper, ApiManager apiManager, DictionaryManager dictionaryManager, OrganizationManager organizationManager, EventManager eventManager, DistributedSyncService distributedSyncService) {
        Supplier<SubscriptionDispatcher> subscriptionDispatcherSupplier = this.provideSubscriptionDispatcher(subscriptionDispatcher);
        return new DeployerFactory(apiKeyService, subscriptionService, planCache, subscriptionDispatcherSupplier, commandRepository, node, objectMapper, apiManager, dictionaryManager, organizationManager, eventManager, distributedSyncService);
    }

    protected Supplier<SubscriptionDispatcher> provideSubscriptionDispatcher(SubscriptionDispatcher subscriptionDispatcher) {
        return () -> {
            SubscriptionDispatcher dispatcher = subscriptionDispatcher;
            try {
                subscriptionDispatcher.lifecycleState();
            }
            catch (NoSuchBeanDefinitionException e) {
                dispatcher = new NoOpSubscriptionDispatcher();
            }
            return dispatcher;
        };
    }

    @Bean
    public SyncProcessProbe syncProcessProbe(List<SyncManager> syncManagers) {
        return new SyncProcessProbe(syncManagers);
    }
}

