/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.definition;

import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.HttpResponse;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.listener.http.Path;
import io.gravitee.gateway.debug.definition.ReactableDebugApi;
import io.gravitee.gateway.debug.reactor.handler.context.PathTransformer;
import lombok.Generated;

public class DebugApiV4
extends io.gravitee.gateway.reactive.handlers.api.v4.Api
implements ReactableDebugApi<Api> {
    private HttpRequest request;
    private HttpResponse response;
    private String eventId;

    public DebugApiV4(String eventId, io.gravitee.definition.model.debug.DebugApiV4 debugApi) {
        super(debugApi.getApiDefinition());
        this.setRequest(debugApi.getRequest());
        this.setResponse(debugApi.getResponse());
        this.setEventId(eventId);
        this.setEnabled(true);
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
        if (((Api)this.definition).getListeners() != null) {
            ((Api)this.definition).getListeners().stream().filter(l -> l.getType() == ListenerType.HTTP).forEach(listener -> {
                HttpListener httpListener = (HttpListener)listener;
                httpListener.getPaths().forEach(path -> path.setPath(PathTransformer.computePathWithEventId(this.eventId, path.getPath())));
            });
        }
    }

    @Override
    public String extractHost() {
        return ((Api)this.definition).getListeners().stream().filter(l -> l.getType() == ListenerType.HTTP).flatMap(listener -> ((HttpListener)listener).getPaths().stream()).findFirst().map(Path::getHost).orElse(null);
    }

    @Override
    public String extractUri() {
        return ((Api)this.definition).getListeners().stream().filter(l -> l.getType() == ListenerType.HTTP).flatMap(listener -> ((HttpListener)listener).getPaths().stream()).map(Path::getPath).findFirst().map(path -> path.endsWith("/") ? path.substring(0, path.length() - 1) : path).orElse("") + this.request.getPath();
    }

    @Override
    @Generated
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    @Generated
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    @Generated
    public String getEventId() {
        return this.eventId;
    }

    @Generated
    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    @Generated
    public void setResponse(HttpResponse response) {
        this.response = response;
    }
}

