/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.vertx;

import io.gravitee.gateway.reactive.reactor.HttpRequestDispatcher;
import io.gravitee.node.vertx.server.http.VertxHttpServer;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.rxjava3.core.AbstractVerticle;
import io.vertx.rxjava3.core.http.HttpServer;
import io.vertx.rxjava3.core.http.HttpServerRequest;
import io.vertx.rxjava3.core.http.HttpServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DebugHttpProtocolVerticle
extends AbstractVerticle {
    private final Logger log = LoggerFactory.getLogger(DebugHttpProtocolVerticle.class);
    private final HttpRequestDispatcher requestDispatcher;
    private final VertxHttpServer debugServer;
    private Disposable requestDisposable;

    public DebugHttpProtocolVerticle(@Qualifier(value="debugServer") VertxHttpServer debugServer, @Qualifier(value="debugHttpRequestDispatcher") HttpRequestDispatcher requestDispatcher) {
        this.debugServer = debugServer;
        this.requestDispatcher = requestDispatcher;
    }

    public Completable rxStart() {
        HttpServer rxHttpServer = this.debugServer.newInstance();
        this.requestDisposable = rxHttpServer.requestStream().toFlowable().flatMapCompletable(this::dispatchRequest).subscribe();
        return rxHttpServer.rxListen().ignoreElement().doOnComplete(() -> this.log.info("Debug HTTP server [{}] ready to accept requests on port {}", (Object)this.debugServer.id(), (Object)rxHttpServer.actualPort())).doOnError(throwable -> this.log.error("Unable to start debug HTTP server [{}]", (Object)this.debugServer.id(), (Object)throwable.getCause())).doOnSubscribe(disposable -> this.log.info("Starting debug HTTP server..."));
    }

    private Completable dispatchRequest(HttpServerRequest request) {
        return this.requestDispatcher.dispatch(request, this.debugServer.id()).doOnComplete(() -> this.log.debug("Request properly dispatched")).onErrorResumeNext(t -> this.handleError((Throwable)t, request.response())).doOnSubscribe(dispatchDisposable -> this.configureCloseHandler(request, (Disposable)dispatchDisposable));
    }

    private Completable handleError(Throwable throwable, HttpServerResponse response) {
        this.log.error("An unexpected error occurred while dispatching request", throwable);
        return this.tryEndResponse(response);
    }

    private Completable tryEndResponse(HttpServerResponse response) {
        try {
            if (!response.ended()) {
                if (!response.headWritten()) {
                    response.setStatusCode(500);
                }
                return response.rxEnd().doOnError(throwable -> this.log.error("Failed to properly end response after error", throwable)).onErrorComplete();
            }
            return Completable.complete();
        }
        catch (Throwable throwable2) {
            this.log.error("Failed to properly end response after error", throwable2);
            return Completable.complete();
        }
    }

    private void configureCloseHandler(HttpServerRequest request, Disposable dispatchDisposable) {
        request.connection().closeHandler(event -> dispatchDisposable.dispose());
    }

    public Completable rxStop() {
        return Completable.fromRunnable(() -> ((Disposable)this.requestDisposable).dispose()).andThen((CompletableSource)this.debugServer.instances().stream().map(rxHttpServer -> rxHttpServer.rxClose().doOnComplete(() -> this.log.info("Debug HTTP Server [{}] has been correctly stopped", (Object)this.debugServer.id()))).findFirst().orElse(Completable.complete())).doOnSubscribe(disposable -> this.log.info("Stopping debug HTTP server..."));
    }
}

