/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.handlers.api;

import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.el.TemplateVariableProvider;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.debug.definition.ReactableDebugApi;
import io.gravitee.gateway.debug.reactor.handler.context.PathTransformer;
import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import io.gravitee.gateway.handlers.accesspoint.manager.AccessPointManager;
import io.gravitee.gateway.opentelemetry.TracingContext;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.reactive.api.hook.SecurityPlanHook;
import io.gravitee.gateway.reactive.core.context.MutableExecutionContext;
import io.gravitee.gateway.reactive.core.v4.endpoint.EndpointManager;
import io.gravitee.gateway.reactive.debug.invoker.DebugInvokerHook;
import io.gravitee.gateway.reactive.debug.policy.DebugPolicyHook;
import io.gravitee.gateway.reactive.handlers.api.v4.DefaultApiReactor;
import io.gravitee.gateway.reactive.handlers.api.v4.flow.FlowChainFactory;
import io.gravitee.gateway.reactive.handlers.api.v4.processor.ApiProcessorChainFactory;
import io.gravitee.gateway.reactive.policy.PolicyManager;
import io.gravitee.gateway.reactor.handler.Acceptor;
import io.gravitee.gateway.reactor.handler.DefaultHttpAcceptor;
import io.gravitee.gateway.reactor.handler.HttpAcceptorFactory;
import io.gravitee.gateway.reactor.handler.ReactorHandler;
import io.gravitee.gateway.report.ReporterService;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.apiservice.ApiServicePluginManager;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.reactivex.rxjava3.core.Completable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DebugV4ApiReactor
extends DefaultApiReactor {
    public DebugV4ApiReactor(io.gravitee.gateway.reactive.handlers.api.v4.Api api, DeploymentContext deploymentContext, ComponentProvider componentProvider, List<TemplateVariableProvider> ctxTemplateVariableProviders, PolicyManager policyManager, EntrypointConnectorPluginManager entrypointConnectorPluginManager, ApiServicePluginManager apiServicePluginManager, EndpointManager endpointManager, ResourceLifecycleManager resourceLifecycleManager, ApiProcessorChainFactory apiProcessorChainFactory, io.gravitee.gateway.reactive.handlers.api.flow.FlowChainFactory flowChainFactory, FlowChainFactory v4FlowChainFactory, Configuration configuration, Node node, RequestTimeoutConfiguration requestTimeoutConfiguration, ReporterService reporterService, AccessPointManager accessPointManager, EventManager eventManager, HttpAcceptorFactory httpAcceptorFactory, TracingContext tracingContext) {
        super(api, deploymentContext, componentProvider, ctxTemplateVariableProviders, policyManager, entrypointConnectorPluginManager, apiServicePluginManager, endpointManager, resourceLifecycleManager, apiProcessorChainFactory, flowChainFactory, v4FlowChainFactory, configuration, node, requestTimeoutConfiguration, reporterService, accessPointManager, eventManager, httpAcceptorFactory, tracingContext);
        this.invokerHooks.add(new DebugInvokerHook());
    }

    public Completable handle(MutableExecutionContext ctx) {
        String debugContextPath = ctx.request().contextPath();
        String cleanContextPath = PathTransformer.removeEventIdFromPath(((ReactableDebugApi)this.api).getEventId(), debugContextPath);
        ctx.request().debugContextPath(cleanContextPath);
        return super.handle(ctx);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.httpSecurityChain.addHooks((Object[])new SecurityPlanHook[]{new DebugPolicyHook()});
    }

    public List<Acceptor<?>> acceptors() {
        try {
            if (this.acceptors == null) {
                this.acceptors = ((Api)this.api.getDefinition()).getListeners().stream().filter(l -> l.getType() == ListenerType.HTTP).flatMap(l -> ((HttpListener)l).getPaths().stream()).map(p -> new DefaultHttpAcceptor(null, p.getPath(), (ReactorHandler)this, null)).collect(Collectors.toList());
            }
            return this.acceptors;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }
}

