/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.policy.steps;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.reactive.api.ExecutionPhase;
import io.gravitee.gateway.reactive.core.context.MutableResponse;
import io.gravitee.gateway.reactive.debug.policy.steps.PolicyStep;
import io.gravitee.gateway.reactive.debug.policy.steps.PolicyStepState;
import io.reactivex.rxjava3.core.Single;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PolicyResponseStep
extends PolicyStep<MutableResponse> {
    public PolicyResponseStep(String policyId, ExecutionPhase executionPhase, String flowPhase) {
        super(policyId, executionPhase, flowPhase);
    }

    @Override
    public Single<PolicyStepState> saveInputState(MutableResponse response, Map<String, Serializable> inputAttributes) {
        return response.bodyOrEmpty().map(inputBody -> new PolicyStepState().headers(response.headers()).statusCode(response.status()).reason(response.reason()).attributes(inputAttributes).buffer((Buffer)inputBody));
    }

    @Override
    public Single<Map<String, Object>> computeDiff(MutableResponse response, PolicyStepState inputState, Map<String, Serializable> outputAttributes) {
        return response.bodyOrEmpty().map(outputBody -> {
            HashMap<String, Object> diffMap = new HashMap<String, Object>();
            if (!inputState.headers().deeplyEquals(response.headers())) {
                diffMap.put("headers", HttpHeaders.create((HttpHeaders)response.headers()));
            }
            if (inputState.statusCode().intValue() != response.status()) {
                diffMap.put("statusCode", response.status());
            }
            if (inputState.reason() != null && !inputState.reason().equals(response.reason())) {
                diffMap.put("reason", response.reason());
            }
            if (!inputState.attributes().equals(outputAttributes)) {
                diffMap.put("attributes", new HashMap(outputAttributes));
            }
            if (!inputState.buffer().getNativeBuffer().equals((Object)outputBody.getNativeBuffer())) {
                diffMap.put("bodyBuffer", Buffer.buffer((byte[])outputBody.getBytes()));
            }
            return diffMap;
        });
    }
}

