/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.handlers.api;

import io.gravitee.common.event.EventManager;
import io.gravitee.el.TemplateVariableProvider;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.endpoint.lifecycle.GroupLifecycleManager;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.reactor.handler.context.PathTransformer;
import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import io.gravitee.gateway.handlers.accesspoint.manager.AccessPointManager;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.opentelemetry.TracingContext;
import io.gravitee.gateway.reactive.api.hook.ChainHook;
import io.gravitee.gateway.reactive.api.hook.InvokerHook;
import io.gravitee.gateway.reactive.api.hook.SecurityPlanHook;
import io.gravitee.gateway.reactive.api.invoker.HttpInvoker;
import io.gravitee.gateway.reactive.core.context.MutableExecutionContext;
import io.gravitee.gateway.reactive.core.processor.ProcessorChain;
import io.gravitee.gateway.reactive.core.v4.analytics.AnalyticsContext;
import io.gravitee.gateway.reactive.debug.invoker.DebugInvokerHook;
import io.gravitee.gateway.reactive.debug.policy.DebugPolicyHook;
import io.gravitee.gateway.reactive.handlers.api.SyncApiReactor;
import io.gravitee.gateway.reactive.handlers.api.flow.FlowChain;
import io.gravitee.gateway.reactive.handlers.api.flow.FlowChainFactory;
import io.gravitee.gateway.reactive.handlers.api.processor.ApiProcessorChainFactory;
import io.gravitee.gateway.reactive.handlers.api.security.HttpSecurityChain;
import io.gravitee.gateway.reactive.policy.PolicyManager;
import io.gravitee.gateway.reactor.handler.Acceptor;
import io.gravitee.gateway.reactor.handler.DefaultHttpAcceptor;
import io.gravitee.gateway.reactor.handler.ReactorHandler;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.configuration.Configuration;
import io.reactivex.rxjava3.core.Completable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class DebugSyncApiReactor
extends SyncApiReactor {
    public DebugSyncApiReactor(Api api, ComponentProvider componentProvider, List<TemplateVariableProvider> templateVariableProviders, HttpInvoker defaultInvoker, ResourceLifecycleManager resourceLifecycleManager, ApiProcessorChainFactory apiProcessorChainFactory, PolicyManager policyManager, FlowChainFactory flowChainFactory, GroupLifecycleManager groupLifecycleManager, Configuration configuration, Node node, RequestTimeoutConfiguration requestTimeoutConfiguration, AccessPointManager accessPointManager, EventManager eventManager, TracingContext tracingContext) {
        super(api, componentProvider, templateVariableProviders, defaultInvoker, resourceLifecycleManager, apiProcessorChainFactory, policyManager, flowChainFactory, groupLifecycleManager, configuration, node, requestTimeoutConfiguration, accessPointManager, eventManager, tracingContext);
        this.invokerHooks.add(new DebugInvokerHook());
    }

    DebugSyncApiReactor(Api api, List<ChainHook> processorChainHooks, List<InvokerHook> invokerHooks, ComponentProvider componentProvider, List<TemplateVariableProvider> templateVariableProviders, HttpInvoker defaultInvoker, ResourceLifecycleManager resourceLifecycleManager, PolicyManager policyManager, GroupLifecycleManager groupLifecycleManager, FlowChain organizationFlowChain, FlowChain apiPlanFlowChain, FlowChain apiFlowChain, ProcessorChain beforeHandleProcessors, ProcessorChain afterHandleProcessors, ProcessorChain beforeSecurityChainProcessors, ProcessorChain beforeApiFlowsProcessors, ProcessorChain afterApiFlowsProcessors, ProcessorChain onErrorProcessors, Configuration configuration, Node node, RequestTimeoutConfiguration requestTimeoutConfiguration, AccessPointManager accessPointManager, EventManager eventManager, TracingContext tracingContext, String loggingExcludedResponseType, String loggingMaxSize, long pendingRequestsTimeout, AnalyticsContext analyticsContext, HttpSecurityChain httpSecurityChain, List<Acceptor<?>> acceptors) {
        super(api, processorChainHooks, invokerHooks, componentProvider, templateVariableProviders, defaultInvoker, resourceLifecycleManager, policyManager, groupLifecycleManager, organizationFlowChain, apiPlanFlowChain, apiFlowChain, beforeHandleProcessors, afterHandleProcessors, beforeSecurityChainProcessors, beforeApiFlowsProcessors, afterApiFlowsProcessors, onErrorProcessors, configuration, node, requestTimeoutConfiguration, accessPointManager, eventManager, tracingContext, loggingExcludedResponseType, loggingMaxSize, pendingRequestsTimeout, analyticsContext, httpSecurityChain, acceptors);
    }

    void handleProcess(MutableExecutionContext ctx) {
        String debugContextPath = ctx.request().contextPath();
        String cleanContextPath = PathTransformer.removeEventIdFromPath(((DebugApi)this.api).getEventId(), debugContextPath);
        ctx.request().debugContextPath(cleanContextPath);
    }

    public Completable handle(MutableExecutionContext ctx) {
        this.handleProcess(ctx);
        return super.handle(ctx);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.httpSecurityChain.addHooks((Object[])new SecurityPlanHook[]{new DebugPolicyHook()});
    }

    public List<Acceptor<?>> acceptors() {
        try {
            if (this.acceptors == null) {
                this.acceptors = ((io.gravitee.definition.model.Api)this.api.getDefinition()).getProxy().getVirtualHosts().stream().map(virtualHost -> new DefaultHttpAcceptor(null, virtualHost.getPath(), (ReactorHandler)this, null)).collect(Collectors.toList());
            }
            return this.acceptors;
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    @Generated
    static DebugSyncApiReactorBuilder builder() {
        return new DebugSyncApiReactorBuilder();
    }

    @Generated
    static class DebugSyncApiReactorBuilder {
        @Generated
        private Api api;
        @Generated
        private List<ChainHook> processorChainHooks;
        @Generated
        private List<InvokerHook> invokerHooks;
        @Generated
        private ComponentProvider componentProvider;
        @Generated
        private List<TemplateVariableProvider> templateVariableProviders;
        @Generated
        private HttpInvoker defaultInvoker;
        @Generated
        private ResourceLifecycleManager resourceLifecycleManager;
        @Generated
        private PolicyManager policyManager;
        @Generated
        private GroupLifecycleManager groupLifecycleManager;
        @Generated
        private FlowChain organizationFlowChain;
        @Generated
        private FlowChain apiPlanFlowChain;
        @Generated
        private FlowChain apiFlowChain;
        @Generated
        private ProcessorChain beforeHandleProcessors;
        @Generated
        private ProcessorChain afterHandleProcessors;
        @Generated
        private ProcessorChain beforeSecurityChainProcessors;
        @Generated
        private ProcessorChain beforeApiFlowsProcessors;
        @Generated
        private ProcessorChain afterApiFlowsProcessors;
        @Generated
        private ProcessorChain onErrorProcessors;
        @Generated
        private Configuration configuration;
        @Generated
        private Node node;
        @Generated
        private RequestTimeoutConfiguration requestTimeoutConfiguration;
        @Generated
        private AccessPointManager accessPointManager;
        @Generated
        private EventManager eventManager;
        @Generated
        private TracingContext tracingContext;
        @Generated
        private String loggingExcludedResponseType;
        @Generated
        private String loggingMaxSize;
        @Generated
        private long pendingRequestsTimeout;
        @Generated
        private AnalyticsContext analyticsContext;
        @Generated
        private HttpSecurityChain httpSecurityChain;
        @Generated
        private List<Acceptor<?>> acceptors;

        @Generated
        DebugSyncApiReactorBuilder() {
        }

        @Generated
        DebugSyncApiReactorBuilder api(Api api) {
            this.api = api;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder processorChainHooks(List<ChainHook> processorChainHooks) {
            this.processorChainHooks = processorChainHooks;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder invokerHooks(List<InvokerHook> invokerHooks) {
            this.invokerHooks = invokerHooks;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder componentProvider(ComponentProvider componentProvider) {
            this.componentProvider = componentProvider;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder templateVariableProviders(List<TemplateVariableProvider> templateVariableProviders) {
            this.templateVariableProviders = templateVariableProviders;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder defaultInvoker(HttpInvoker defaultInvoker) {
            this.defaultInvoker = defaultInvoker;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder resourceLifecycleManager(ResourceLifecycleManager resourceLifecycleManager) {
            this.resourceLifecycleManager = resourceLifecycleManager;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder policyManager(PolicyManager policyManager) {
            this.policyManager = policyManager;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder groupLifecycleManager(GroupLifecycleManager groupLifecycleManager) {
            this.groupLifecycleManager = groupLifecycleManager;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder organizationFlowChain(FlowChain organizationFlowChain) {
            this.organizationFlowChain = organizationFlowChain;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder apiPlanFlowChain(FlowChain apiPlanFlowChain) {
            this.apiPlanFlowChain = apiPlanFlowChain;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder apiFlowChain(FlowChain apiFlowChain) {
            this.apiFlowChain = apiFlowChain;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder beforeHandleProcessors(ProcessorChain beforeHandleProcessors) {
            this.beforeHandleProcessors = beforeHandleProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder afterHandleProcessors(ProcessorChain afterHandleProcessors) {
            this.afterHandleProcessors = afterHandleProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder beforeSecurityChainProcessors(ProcessorChain beforeSecurityChainProcessors) {
            this.beforeSecurityChainProcessors = beforeSecurityChainProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder beforeApiFlowsProcessors(ProcessorChain beforeApiFlowsProcessors) {
            this.beforeApiFlowsProcessors = beforeApiFlowsProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder afterApiFlowsProcessors(ProcessorChain afterApiFlowsProcessors) {
            this.afterApiFlowsProcessors = afterApiFlowsProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder onErrorProcessors(ProcessorChain onErrorProcessors) {
            this.onErrorProcessors = onErrorProcessors;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder node(Node node) {
            this.node = node;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder requestTimeoutConfiguration(RequestTimeoutConfiguration requestTimeoutConfiguration) {
            this.requestTimeoutConfiguration = requestTimeoutConfiguration;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder accessPointManager(AccessPointManager accessPointManager) {
            this.accessPointManager = accessPointManager;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder eventManager(EventManager eventManager) {
            this.eventManager = eventManager;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder tracingContext(TracingContext tracingContext) {
            this.tracingContext = tracingContext;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder loggingExcludedResponseType(String loggingExcludedResponseType) {
            this.loggingExcludedResponseType = loggingExcludedResponseType;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder loggingMaxSize(String loggingMaxSize) {
            this.loggingMaxSize = loggingMaxSize;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder pendingRequestsTimeout(long pendingRequestsTimeout) {
            this.pendingRequestsTimeout = pendingRequestsTimeout;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder analyticsContext(AnalyticsContext analyticsContext) {
            this.analyticsContext = analyticsContext;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder httpSecurityChain(HttpSecurityChain httpSecurityChain) {
            this.httpSecurityChain = httpSecurityChain;
            return this;
        }

        @Generated
        DebugSyncApiReactorBuilder acceptors(List<Acceptor<?>> acceptors) {
            this.acceptors = acceptors;
            return this;
        }

        @Generated
        DebugSyncApiReactor build() {
            return new DebugSyncApiReactor(this.api, this.processorChainHooks, this.invokerHooks, this.componentProvider, this.templateVariableProviders, this.defaultInvoker, this.resourceLifecycleManager, this.policyManager, this.groupLifecycleManager, this.organizationFlowChain, this.apiPlanFlowChain, this.apiFlowChain, this.beforeHandleProcessors, this.afterHandleProcessors, this.beforeSecurityChainProcessors, this.beforeApiFlowsProcessors, this.afterApiFlowsProcessors, this.onErrorProcessors, this.configuration, this.node, this.requestTimeoutConfiguration, this.accessPointManager, this.eventManager, this.tracingContext, this.loggingExcludedResponseType, this.loggingMaxSize, this.pendingRequestsTimeout, this.analyticsContext, this.httpSecurityChain, this.acceptors);
        }

        @Generated
        public String toString() {
            return "DebugSyncApiReactor.DebugSyncApiReactorBuilder(api=" + String.valueOf(this.api) + ", processorChainHooks=" + String.valueOf(this.processorChainHooks) + ", invokerHooks=" + String.valueOf(this.invokerHooks) + ", componentProvider=" + String.valueOf(this.componentProvider) + ", templateVariableProviders=" + String.valueOf(this.templateVariableProviders) + ", defaultInvoker=" + String.valueOf(this.defaultInvoker) + ", resourceLifecycleManager=" + String.valueOf(this.resourceLifecycleManager) + ", policyManager=" + String.valueOf(this.policyManager) + ", groupLifecycleManager=" + String.valueOf(this.groupLifecycleManager) + ", organizationFlowChain=" + String.valueOf(this.organizationFlowChain) + ", apiPlanFlowChain=" + String.valueOf(this.apiPlanFlowChain) + ", apiFlowChain=" + String.valueOf(this.apiFlowChain) + ", beforeHandleProcessors=" + String.valueOf(this.beforeHandleProcessors) + ", afterHandleProcessors=" + String.valueOf(this.afterHandleProcessors) + ", beforeSecurityChainProcessors=" + String.valueOf(this.beforeSecurityChainProcessors) + ", beforeApiFlowsProcessors=" + String.valueOf(this.beforeApiFlowsProcessors) + ", afterApiFlowsProcessors=" + String.valueOf(this.afterApiFlowsProcessors) + ", onErrorProcessors=" + String.valueOf(this.onErrorProcessors) + ", configuration=" + String.valueOf(this.configuration) + ", node=" + String.valueOf(this.node) + ", requestTimeoutConfiguration=" + String.valueOf(this.requestTimeoutConfiguration) + ", accessPointManager=" + String.valueOf(this.accessPointManager) + ", eventManager=" + String.valueOf(this.eventManager) + ", tracingContext=" + String.valueOf(this.tracingContext) + ", loggingExcludedResponseType=" + this.loggingExcludedResponseType + ", loggingMaxSize=" + this.loggingMaxSize + ", pendingRequestsTimeout=" + this.pendingRequestsTimeout + ", analyticsContext=" + String.valueOf(this.analyticsContext) + ", httpSecurityChain=" + String.valueOf(this.httpSecurityChain) + ", acceptors=" + String.valueOf(this.acceptors) + ")";
        }
    }
}

