/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.policy.impl;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.handler.Handler;
import io.gravitee.gateway.api.stream.ReadStream;
import io.gravitee.gateway.api.stream.ReadWriteStream;
import io.gravitee.gateway.api.stream.WriteStream;
import io.gravitee.gateway.debug.reactor.handler.context.DebugExecutionContext;
import io.gravitee.gateway.debug.reactor.handler.context.steps.DebugStep;

public class DebugReadWriteStream
implements ReadWriteStream<Buffer> {
    private final ReadWriteStream<Buffer> delegate;
    private final DebugStep<?> debugStep;
    private final DebugExecutionContext context;
    private Buffer outputBuffer;
    private Buffer inputBuffer;

    public DebugReadWriteStream(DebugExecutionContext context, ReadWriteStream<Buffer> delegate, DebugStep<?> debugStep) {
        this.context = context;
        this.delegate = delegate;
        this.debugStep = debugStep;
    }

    public ReadStream<Buffer> bodyHandler(Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler(buf -> {
            if (this.outputBuffer == null) {
                this.outputBuffer = Buffer.buffer();
            }
            this.outputBuffer.appendBuffer(buf);
            this.context.afterPolicyExecution(this.debugStep, this.inputBuffer, this.outputBuffer);
            bodyHandler.handle(buf);
        });
        return this;
    }

    public ReadStream<Buffer> endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(avoid -> {
            this.context.afterPolicyExecution(this.debugStep, this.inputBuffer, this.outputBuffer);
            endHandler.handle(null);
        });
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.delegate.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.delegate.resume();
        return this;
    }

    public WriteStream<Buffer> write(Buffer chunk) {
        if (this.inputBuffer == null) {
            this.inputBuffer = Buffer.buffer();
        }
        this.context.beforePolicyExecution(this.debugStep);
        this.inputBuffer.appendBuffer(chunk);
        this.delegate.write((Object)chunk);
        return this;
    }

    public void end() {
        this.context.beforePolicyExecution(this.debugStep);
        this.delegate.end();
    }

    public void end(Buffer chunk) {
        this.delegate.end((Object)chunk);
    }

    public WriteStream<Buffer> drainHandler(Handler<Void> drainHandler) {
        this.delegate.drainHandler(drainHandler);
        return this;
    }

    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }
}

