/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.http.IdGenerator;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.gateway.core.classloader.DefaultClassLoader;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.condition.ConditionEvaluator;
import io.gravitee.gateway.core.condition.ExpressionLanguageStringConditionEvaluator;
import io.gravitee.gateway.debug.handlers.api.DebugApiReactorHandlerFactory;
import io.gravitee.gateway.debug.platform.manager.DebugOrganizationManager;
import io.gravitee.gateway.debug.policy.impl.PolicyDebugDecoratorFactoryCreator;
import io.gravitee.gateway.debug.reactor.DebugReactor;
import io.gravitee.gateway.debug.reactor.processor.DebugResponseProcessorChainFactory;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.debug.vertx.VertxDebugService;
import io.gravitee.gateway.env.GatewayConfiguration;
import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import io.gravitee.gateway.flow.FlowPolicyResolverFactory;
import io.gravitee.gateway.flow.FlowResolver;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.platform.OrganizationFlowResolver;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import io.gravitee.gateway.platform.providers.OnRequestPlatformPolicyChainProvider;
import io.gravitee.gateway.platform.providers.OnResponsePlatformPolicyChainProvider;
import io.gravitee.gateway.policy.ConfigurablePolicyChainProvider;
import io.gravitee.gateway.policy.PolicyChainProviderLoader;
import io.gravitee.gateway.policy.PolicyConfigurationFactory;
import io.gravitee.gateway.policy.PolicyFactoryCreator;
import io.gravitee.gateway.policy.PolicyManager;
import io.gravitee.gateway.policy.PolicyPluginFactory;
import io.gravitee.gateway.policy.impl.PolicyFactoryCreatorImpl;
import io.gravitee.gateway.reactive.core.condition.ExpressionLanguageConditionFilter;
import io.gravitee.gateway.reactive.debug.DebugReactorEventListener;
import io.gravitee.gateway.reactive.debug.policy.DebugPolicyChainFactory;
import io.gravitee.gateway.reactive.debug.policy.condition.DebugExpressionLanguageConditionFilter;
import io.gravitee.gateway.reactive.debug.reactor.DebugHttpRequestDispatcher;
import io.gravitee.gateway.reactive.debug.reactor.processor.DebugPlatformProcessorChainFactory;
import io.gravitee.gateway.reactive.handlers.api.flow.resolver.FlowResolverFactory;
import io.gravitee.gateway.reactive.handlers.api.processor.ApiProcessorChainFactory;
import io.gravitee.gateway.reactive.platform.PlatformPolicyManager;
import io.gravitee.gateway.reactive.policy.DefaultPolicyFactory;
import io.gravitee.gateway.reactive.policy.PolicyChainFactory;
import io.gravitee.gateway.reactive.policy.PolicyFactory;
import io.gravitee.gateway.reactive.reactor.HttpRequestDispatcher;
import io.gravitee.gateway.reactive.reactor.handler.DefaultHttpAcceptorResolver;
import io.gravitee.gateway.reactive.reactor.handler.HttpAcceptorResolver;
import io.gravitee.gateway.reactive.reactor.processor.transaction.TransactionPreProcessorFactory;
import io.gravitee.gateway.reactive.reactor.v4.reactor.ReactorFactory;
import io.gravitee.gateway.reactive.reactor.v4.reactor.ReactorFactoryManager;
import io.gravitee.gateway.reactor.Reactor;
import io.gravitee.gateway.reactor.handler.AcceptorResolver;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.handler.impl.DefaultAcceptorResolver;
import io.gravitee.gateway.reactor.handler.impl.DefaultReactorHandlerRegistry;
import io.gravitee.gateway.reactor.processor.NotFoundProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.RequestProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.ResponseProcessorChainFactory;
import io.gravitee.gateway.report.ReporterService;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.node.api.Node;
import io.gravitee.plugin.alert.AlertEventProducer;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.repository.management.api.EventRepository;
import io.vertx.core.Vertx;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;

@Configuration
public class DebugConfiguration {
    private final ApplicationContext applicationContext;
    private final Node node;
    private final io.gravitee.node.api.configuration.Configuration configuration;

    public DebugConfiguration(ApplicationContext applicationContext, Node node, io.gravitee.node.api.configuration.Configuration configuration) {
        this.applicationContext = applicationContext;
        this.node = node;
        this.configuration = configuration;
    }

    @Bean
    public PolicyFactoryCreator debugV3PolicyFactoryCreator(PolicyPluginFactory policyPluginFactory) {
        return new PolicyDebugDecoratorFactoryCreator((PolicyFactoryCreator)new PolicyFactoryCreatorImpl(this.configuration, policyPluginFactory, (ConditionEvaluator)new ExpressionLanguageStringConditionEvaluator()));
    }

    @Bean
    public AcceptorResolver debugV3EntrypointResolver(@Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry reactorHandlerRegistry) {
        return new DefaultAcceptorResolver(reactorHandlerRegistry);
    }

    @Bean
    public Reactor debugReactor(@Qualifier(value="debugV3EntrypointResolver") AcceptorResolver acceptorResolver, GatewayConfiguration gatewayConfiguration, @Qualifier(value="v3RequestProcessorChainFactory") RequestProcessorChainFactory requestProcessorChainFactory, @Qualifier(value="debugV3ResponseProcessorChainFactory") ResponseProcessorChainFactory responseProcessorChainFactory, @Qualifier(value="v3NotFoundProcessorChainFactory") NotFoundProcessorChainFactory notFoundProcessorChainFactory) {
        return new DebugReactor(acceptorResolver, gatewayConfiguration, requestProcessorChainFactory, responseProcessorChainFactory, notFoundProcessorChainFactory);
    }

    @Bean
    public PolicyChainProviderLoader debugV3PolicyChainProviderLoader(@Qualifier(value="debugV3ConfigurablePolicyChainProvider") List<ConfigurablePolicyChainProvider> providers) {
        return new PolicyChainProviderLoader(providers);
    }

    @Bean
    @Qualifier(value="debugV3ConfigurablePolicyChainProvider")
    public OnRequestPlatformPolicyChainProvider debugV3OnRequestPlatformPolicyChainProvider(@Qualifier(value="debugV3FlowResolver") FlowResolver flowResolver, @Qualifier(value="debugV3PlatformPolicyChainFactory") io.gravitee.gateway.flow.policy.PolicyChainFactory policyChainFactory) {
        return new OnRequestPlatformPolicyChainProvider(flowResolver, policyChainFactory, new FlowPolicyResolverFactory());
    }

    @Bean
    @Qualifier(value="debugV3ConfigurablePolicyChainProvider")
    public OnResponsePlatformPolicyChainProvider debugV3OnResponsePlatformPolicyChainProvider(@Qualifier(value="debugV3FlowResolver") FlowResolver flowResolver, @Qualifier(value="debugV3PlatformPolicyChainFactory") io.gravitee.gateway.flow.policy.PolicyChainFactory policyChainFactory) {
        return new OnResponsePlatformPolicyChainProvider(flowResolver, policyChainFactory, new FlowPolicyResolverFactory());
    }

    @Bean
    public io.gravitee.gateway.platform.PlatformPolicyManager debugV3PlatformPolicyManager(@Qualifier(value="debugV3PolicyFactoryCreator") PolicyFactoryCreator factory, PolicyConfigurationFactory policyConfigurationFactory, PolicyClassLoaderFactory policyClassLoaderFactory, ResourceLifecycleManager resourceLifecycleManager, ComponentProvider componentProvider) {
        ApplicationContext contextParent = this.applicationContext.getParent();
        String[] beanNamesForType = contextParent.getBeanNamesForType(ResolvableType.forClassWithGenerics(ConfigurablePluginManager.class, (Class[])new Class[]{PolicyPlugin.class}));
        ConfigurablePluginManager cpm = (ConfigurablePluginManager)contextParent.getBean(beanNamesForType[0]);
        return new io.gravitee.gateway.platform.PlatformPolicyManager(((Boolean)this.configuration.getProperty("classloader.legacy.enabled", Boolean.class, (Object)false)).booleanValue(), (DefaultClassLoader)contextParent.getBean(DefaultClassLoader.class), factory.create(), policyConfigurationFactory, cpm, policyClassLoaderFactory, resourceLifecycleManager, componentProvider);
    }

    @Bean
    public ResponseProcessorChainFactory debugV3ResponseProcessorChainFactory(EventRepository eventRepository, ObjectMapper objectMapper) {
        return new DebugResponseProcessorChainFactory(eventRepository, objectMapper);
    }

    @Bean
    public OrganizationManager debugV3OrganizationManager(@Qualifier(value="debugV3PlatformPolicyManager") io.gravitee.gateway.platform.PlatformPolicyManager policyManager, EventManager eventManager) {
        return new DebugOrganizationManager(policyManager, eventManager);
    }

    @Bean
    public FlowResolver debugV3FlowResolver(@Qualifier(value="debugV3OrganizationManager") OrganizationManager organizationManager) {
        return new OrganizationFlowResolver(organizationManager);
    }

    @Bean
    public io.gravitee.gateway.flow.policy.PolicyChainFactory debugV3PlatformPolicyChainFactory(@Qualifier(value="debugV3PlatformPolicyManager") io.gravitee.gateway.platform.PlatformPolicyManager platformPolicyManager) {
        return new io.gravitee.gateway.flow.policy.PolicyChainFactory((PolicyManager)platformPolicyManager);
    }

    @Bean
    public DebugReactorEventListener debugReactorEventListener(io.vertx.rxjava3.core.Vertx vertx, EventManager eventManager, EventRepository eventRepository, ObjectMapper objectMapper, VertxDebugHttpClientConfiguration debugHttpClientConfiguration, @Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry reactorHandlerRegistry, OrganizationManager organizationManager, DataEncryptor dataEncryptor) {
        return new DebugReactorEventListener(vertx, eventManager, eventRepository, objectMapper, debugHttpClientConfiguration, reactorHandlerRegistry, organizationManager, dataEncryptor);
    }

    @Bean
    public PolicyChainFactory debugPlatformPolicyChainFactory(io.gravitee.node.api.configuration.Configuration configuration, PlatformPolicyManager platformPolicyManager) {
        return new DebugPolicyChainFactory("platform", (io.gravitee.gateway.reactive.policy.PolicyManager)platformPolicyManager, configuration);
    }

    @Bean
    public PolicyFactory debugPolicyFactory(PolicyPluginFactory policyPluginFactory) {
        return new DefaultPolicyFactory(policyPluginFactory, (ExpressionLanguageConditionFilter)new DebugExpressionLanguageConditionFilter());
    }

    @Bean
    public HttpRequestDispatcher debugHttpRequestDispatcher(GatewayConfiguration gatewayConfiguration, @Qualifier(value="debugHttpAcceptorResolver") HttpAcceptorResolver httpAcceptorResolver, IdGenerator idGenerator, ComponentProvider globalComponentProvider, RequestProcessorChainFactory v3RequestProcessorChainFactory, @Qualifier(value="debugV3ResponseProcessorChainFactory") ResponseProcessorChainFactory v3ResponseProcessorChainFactory, @Qualifier(value="debugPlatformProcessorChainFactory") DebugPlatformProcessorChainFactory debugPlatformProcessorChainFactory, io.gravitee.gateway.reactive.reactor.processor.NotFoundProcessorChainFactory notFoundProcessorChainFactory, @Value(value="${services.tracing.enabled:false}") boolean tracingEnabled, RequestTimeoutConfiguration requestTimeoutConfiguration, Vertx vertx) {
        return new DebugHttpRequestDispatcher(gatewayConfiguration, httpAcceptorResolver, idGenerator, globalComponentProvider, v3RequestProcessorChainFactory, v3ResponseProcessorChainFactory, debugPlatformProcessorChainFactory, notFoundProcessorChainFactory, tracingEnabled, requestTimeoutConfiguration, vertx);
    }

    @Bean
    public HttpAcceptorResolver debugHttpAcceptorResolver(@Qualifier(value="debugReactorHandlerRegistry") ReactorHandlerRegistry debugReactorHandlerRegistry) {
        return new DefaultHttpAcceptorResolver(debugReactorHandlerRegistry);
    }

    @Bean
    public DebugPlatformProcessorChainFactory debugPlatformProcessorChainFactory(TransactionPreProcessorFactory transactionHandlerFactory, @Value(value="${handlers.request.trace-context.enabled:false}") boolean traceContext, @Value(value="${handlers.request.x-forward.enabled:false}") boolean xForwardProcessor, ReporterService reporterService, AlertEventProducer eventProducer, Node node, @Value(value="${debug.http.port:8482}") String httpPort, @Value(value="${services.tracing.enabled:false}") boolean tracing, GatewayConfiguration gatewayConfiguration, EventRepository eventRepository, ObjectMapper objectMapper) {
        return new DebugPlatformProcessorChainFactory(transactionHandlerFactory, traceContext, xForwardProcessor, reporterService, eventProducer, node, httpPort, tracing, gatewayConfiguration, eventRepository, objectMapper);
    }

    @Bean
    public VertxDebugService vertxDebugService() {
        return new VertxDebugService();
    }

    @Bean
    public ReactorFactory<Api> debugReactorHandlerFactory(@Qualifier(value="debugV3PolicyFactoryCreator") PolicyFactoryCreator v3PolicyFactoryCreator, @Qualifier(value="debugPolicyFactory") PolicyFactory policyFactory, @Qualifier(value="debugPlatformPolicyChainFactory") PolicyChainFactory platformPolicyChainFactory, OrganizationManager organizationManager, @Qualifier(value="debugV3PolicyChainProviderLoader") PolicyChainProviderLoader policyChainProviderLoader, ApiProcessorChainFactory apiProcessorChainFactory, FlowResolverFactory flowResolverFactory, RequestTimeoutConfiguration requestTimeoutConfiguration) {
        return new DebugApiReactorHandlerFactory(this.applicationContext.getParent(), this.configuration, this.node, v3PolicyFactoryCreator, policyFactory, platformPolicyChainFactory, organizationManager, policyChainProviderLoader, apiProcessorChainFactory, flowResolverFactory, requestTimeoutConfiguration);
    }

    @Bean
    public ReactorFactoryManager debugReactorHandlerFactoryManager(@Qualifier(value="debugReactorHandlerFactory") List<ReactorFactory> reactorFactories) {
        return new ReactorFactoryManager(reactorFactories);
    }

    @Bean
    public ReactorHandlerRegistry debugReactorHandlerRegistry(@Qualifier(value="debugReactorHandlerFactoryManager") ReactorFactoryManager reactorFactoryManager) {
        return new DefaultReactorHandlerRegistry(reactorFactoryManager);
    }
}

