/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.reactive.debug.hook;

import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.ExecutionPhase;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.GenericExecutionContext;
import io.gravitee.gateway.reactive.api.hook.Hook;
import io.gravitee.gateway.reactive.debug.reactor.context.DebugExecutionContext;
import io.reactivex.rxjava3.core.Completable;

public abstract class AbstractDebugHook
implements Hook {
    public Completable pre(String id, ExecutionContext ctx, ExecutionPhase executionPhase) {
        DebugExecutionContext debugCtx = this.getExecutionContext((GenericExecutionContext)ctx);
        if (debugCtx != null) {
            return this.pre(id, debugCtx, executionPhase);
        }
        return this.errorOnWrongContext();
    }

    protected abstract Completable pre(String var1, DebugExecutionContext var2, ExecutionPhase var3);

    public Completable post(String id, ExecutionContext ctx, ExecutionPhase executionPhase) {
        DebugExecutionContext debugCtx = this.getExecutionContext((GenericExecutionContext)ctx);
        if (debugCtx != null) {
            return this.post(id, debugCtx, executionPhase);
        }
        return this.errorOnWrongContext();
    }

    protected abstract Completable post(String var1, DebugExecutionContext var2, ExecutionPhase var3);

    public Completable error(String id, ExecutionContext ctx, ExecutionPhase executionPhase, Throwable throwable) {
        DebugExecutionContext debugCtx = this.getExecutionContext((GenericExecutionContext)ctx);
        if (debugCtx != null) {
            return this.error(id, debugCtx, executionPhase, throwable);
        }
        return this.errorOnWrongContext();
    }

    protected abstract Completable error(String var1, DebugExecutionContext var2, ExecutionPhase var3, Throwable var4);

    public Completable interrupt(String id, ExecutionContext ctx, ExecutionPhase executionPhase) {
        DebugExecutionContext debugCtx = this.getExecutionContext((GenericExecutionContext)ctx);
        if (debugCtx != null) {
            return this.interrupt(id, debugCtx, executionPhase);
        }
        return this.errorOnWrongContext();
    }

    protected abstract Completable interrupt(String var1, DebugExecutionContext var2, ExecutionPhase var3);

    public Completable interruptWith(String id, ExecutionContext ctx, ExecutionPhase executionPhase, ExecutionFailure failure) {
        return Completable.defer(() -> {
            DebugExecutionContext debugCtx = this.getExecutionContext((GenericExecutionContext)ctx);
            if (debugCtx != null) {
                return this.interruptWith(id, debugCtx, executionPhase, failure);
            }
            return this.errorOnWrongContext();
        });
    }

    protected abstract Completable interruptWith(String var1, DebugExecutionContext var2, ExecutionPhase var3, ExecutionFailure var4);

    private DebugExecutionContext getExecutionContext(GenericExecutionContext ctx) {
        if (ctx instanceof DebugExecutionContext) {
            return (DebugExecutionContext)ctx;
        }
        return null;
    }

    private Completable errorOnWrongContext() {
        return Completable.error((Throwable)new IllegalArgumentException("Given context is not a DebugExecutionContext"));
    }
}

