/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpServerOptions;
import io.gravitee.gateway.reactive.debug.vertx.DebugHttpProtocolVerticle;
import io.gravitee.gateway.reactive.reactor.HttpRequestDispatcher;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.server.http.VertxHttpServer;
import io.gravitee.node.vertx.server.http.VertxHttpServerFactory;
import io.gravitee.node.vertx.server.http.VertxHttpServerOptions;
import io.vertx.core.Verticle;
import io.vertx.rxjava3.core.Vertx;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
public class VertxDebugConfiguration {
    @Bean(value={"debugHttpClientConfiguration"})
    public VertxDebugHttpClientConfiguration debugHttpClientConfiguration(@Qualifier(value="debugServer") VertxHttpServer debugServer, Environment environment) {
        VertxHttpServerOptions options = debugServer.options();
        return VertxDebugHttpClientConfiguration.builder().port(options.getPort()).host(options.getHost()).secured(options.isSecured()).openssl(options.isOpenssl()).compressionSupported(options.isCompressionSupported()).alpn(options.isAlpn()).connectTimeout((Integer)environment.getProperty("debug.timeout.connect", Integer.class, (Object)5000)).requestTimeout((Integer)environment.getProperty("debug.timeout.request", Integer.class, (Object)10000)).build();
    }

    @Bean(value={"debugServerFactory"})
    public VertxHttpServerFactory debugHttpServerFactory(Vertx vertx) {
        return new VertxHttpServerFactory(vertx);
    }

    @Bean(value={"debugServer"})
    public VertxHttpServer debugServer(VertxHttpServerFactory debugHttpServerFactory, Environment environment, KeyStoreLoaderManager keyStoreLoaderManager) {
        VertxHttpServerOptions.VertxHttpServerOptionsBuilder optionsBuilder = environment.getProperty("servers[0].type") != null ? (VertxHttpServerOptions.VertxHttpServerOptionsBuilder)((VertxDebugHttpServerOptions.VertxDebugHttpServerOptionsBuilder)VertxDebugHttpServerOptions.builder().prefix("servers[0]")).environment(environment).keyStoreLoaderManager(keyStoreLoaderManager) : (VertxHttpServerOptions.VertxHttpServerOptionsBuilder)((VertxDebugHttpServerOptions.VertxDebugHttpServerOptionsBuilder)VertxDebugHttpServerOptions.builder().prefix("http")).environment(environment).keyStoreLoaderManager(keyStoreLoaderManager);
        return debugHttpServerFactory.create(optionsBuilder.build());
    }

    @Bean
    @Scope(value="singleton")
    public Verticle debugVerticle(@Qualifier(value="debugServer") VertxHttpServer debugServer, @Qualifier(value="debugHttpRequestDispatcher") HttpRequestDispatcher requestDispatcher) {
        return new DebugHttpProtocolVerticle(debugServer, requestDispatcher);
    }
}

