/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.platform.manager;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.Policy;
import io.gravitee.gateway.platform.Organization;
import io.gravitee.gateway.platform.PlatformPolicyManager;
import io.gravitee.gateway.platform.manager.OrganizationEvent;
import io.gravitee.gateway.platform.manager.OrganizationManager;

public class DebugOrganizationManager
implements OrganizationManager,
EventListener<OrganizationEvent, Organization> {
    private Organization currentOrganization;
    private final PlatformPolicyManager policyManager;

    public DebugOrganizationManager(PlatformPolicyManager policyManager, EventManager eventManager) {
        this.policyManager = policyManager;
        eventManager.subscribeForEvents((EventListener)this, OrganizationEvent.class);
    }

    public boolean register(Organization organization) {
        this.currentOrganization = organization;
        this.policyManager.setDependencies(this.currentOrganization.dependencies(Policy.class));
        return true;
    }

    public void unregister(String orgId) {
        this.currentOrganization = null;
    }

    public Organization getCurrentOrganization() {
        return this.currentOrganization;
    }

    public void onEvent(Event<OrganizationEvent, Organization> event) {
        switch ((OrganizationEvent)event.type()) {
            case REGISTER: {
                this.register((Organization)event.content());
                break;
            }
            case UNREGISTER: {
                this.unregister(((Organization)event.content()).getId());
            }
        }
    }
}

