/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.debug.reactor.context;

import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.debug.core.invoker.InvokerResponse;
import io.gravitee.gateway.debug.reactor.handler.context.AttributeHelper;
import io.gravitee.gateway.jupiter.api.ExecutionFailure;
import io.gravitee.gateway.jupiter.api.ExecutionPhase;
import io.gravitee.gateway.jupiter.core.context.MutableRequest;
import io.gravitee.gateway.jupiter.core.context.MutableResponse;
import io.gravitee.gateway.jupiter.debug.policy.steps.PolicyRequestStep;
import io.gravitee.gateway.jupiter.debug.policy.steps.PolicyResponseStep;
import io.gravitee.gateway.jupiter.debug.policy.steps.PolicyStep;
import io.gravitee.gateway.jupiter.debug.policy.steps.PolicyStepFactory;
import io.gravitee.gateway.jupiter.reactor.handler.context.DefaultExecutionContext;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DebugExecutionContext
extends DefaultExecutionContext {
    private final LinkedList<PolicyStep<?>> policySteps = new LinkedList();
    private final Map<String, Serializable> initialAttributes;
    private final InvokerResponse invokerResponse = new InvokerResponse();
    private final HttpHeaders initialHeaders;

    public DebugExecutionContext(MutableRequest request, MutableResponse response) {
        super(request, response);
        this.initialAttributes = AttributeHelper.filterAndSerializeAttributes(this.getAttributes());
        this.initialHeaders = HttpHeaders.create((HttpHeaders)((MutableRequest)this.request()).headers());
    }

    public Completable prePolicyExecution(String id, ExecutionPhase executionPhase) {
        return Maybe.fromCallable(() -> {
            String flowStage = (String)this.getInternalAttribute("flow.stage");
            PolicyStep<?> policyStep = PolicyStepFactory.createPolicyStep(id, executionPhase, flowStage);
            if (policyStep != null) {
                this.policySteps.add(policyStep);
                return policyStep;
            }
            return null;
        }).flatMapCompletable(currentPolicyStep -> {
            if (ExecutionPhase.REQUEST == currentPolicyStep.getExecutionPhase()) {
                return ((PolicyRequestStep)currentPolicyStep).pre((MutableRequest)this.request(), this.getAttributes());
            }
            if (ExecutionPhase.RESPONSE == currentPolicyStep.getExecutionPhase()) {
                return ((PolicyResponseStep)currentPolicyStep).pre((MutableResponse)this.response(), this.getAttributes());
            }
            return Completable.complete();
        });
    }

    public Completable postPolicyExecution() {
        return Completable.defer(() -> {
            PolicyStep<?> currentPolicyStep = this.getCurrentDebugStep();
            if (currentPolicyStep != null && !currentPolicyStep.isEnded()) {
                if (ExecutionPhase.REQUEST == currentPolicyStep.getExecutionPhase()) {
                    return ((PolicyRequestStep)currentPolicyStep).post((MutableRequest)this.request(), this.getAttributes());
                }
                if (ExecutionPhase.RESPONSE == currentPolicyStep.getExecutionPhase()) {
                    return ((PolicyResponseStep)currentPolicyStep).post((MutableResponse)this.response(), this.getAttributes());
                }
            }
            return Completable.complete();
        }).doOnComplete(() -> {
            PolicyStep<?> currentPolicyStep = this.getCurrentDebugStep();
            if (currentPolicyStep != null) {
                currentPolicyStep.end();
            }
        });
    }

    public Completable postPolicyExecution(Throwable throwable) {
        return Completable.defer(() -> {
            PolicyStep<?> currentPolicyStep = this.getCurrentDebugStep();
            if (currentPolicyStep != null && !currentPolicyStep.isEnded()) {
                return currentPolicyStep.error(throwable).doOnComplete(currentPolicyStep::end);
            }
            return Completable.complete();
        });
    }

    public Completable postPolicyExecution(ExecutionFailure executionFailure) {
        return Completable.defer(() -> {
            PolicyStep<?> currentPolicyStep = this.getCurrentDebugStep();
            if (currentPolicyStep != null && !currentPolicyStep.isEnded()) {
                return currentPolicyStep.error(executionFailure).doOnComplete(currentPolicyStep::end);
            }
            return Completable.complete();
        });
    }

    public Map<String, Serializable> getInitialAttributes() {
        return this.initialAttributes;
    }

    public HttpHeaders getInitialHeaders() {
        return this.initialHeaders;
    }

    public PolicyStep<?> getCurrentDebugStep() {
        return this.policySteps.getLast();
    }

    public List<PolicyStep<?>> getDebugSteps() {
        return this.policySteps;
    }

    public InvokerResponse getInvokerResponse() {
        return this.invokerResponse;
    }
}

