/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.gateway.debug.vertx.DebugReactorVerticle;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.jupiter.debug.vertx.DebugHttpProtocolVerticle;
import io.gravitee.gateway.jupiter.reactor.HttpRequestDispatcher;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.VertxHttpServerFactory;
import io.gravitee.node.vertx.configuration.HttpServerConfiguration;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
public class VertxDebugConfiguration {
    @Value(value="${api.jupiterMode.enabled:false}")
    private boolean jupiterMode;

    @Bean(value={"debugHttpServerConfiguration"})
    public HttpServerConfiguration debugHttpServerConfiguration(Environment environment) {
        return HttpServerConfiguration.builder().withEnvironment(environment).withPort(Integer.parseInt(environment.getProperty("debug.port", "8482"))).withHost(environment.getProperty("debug.host", "localhost")).build().withSecured(Boolean.TRUE.equals(environment.getProperty("http.secured", Boolean.class))).withAlpn(Boolean.TRUE.equals(environment.getProperty("http.alpn", Boolean.class))).withOpenssl(Boolean.TRUE.equals(environment.getProperty("http.ssl.openssl", Boolean.class))).withProxyProtocol(false);
    }

    @Bean(value={"debugGatewayHttpServer"})
    public VertxHttpServerFactory debugGatewayHttpServer(Vertx vertx, @Qualifier(value="debugHttpServerConfiguration") HttpServerConfiguration httpServerConfiguration, KeyStoreLoaderManager keyStoreLoaderManager) {
        return new VertxHttpServerFactory(vertx, httpServerConfiguration, keyStoreLoaderManager);
    }

    @Bean(value={"debugHttpClientConfiguration"})
    public VertxDebugHttpClientConfiguration debugHttpClientConfiguration() {
        return new VertxDebugHttpClientConfiguration();
    }

    @Bean
    @Scope(value="singleton")
    public Verticle debugVerticle(@Qualifier(value="debugGatewayHttpServer") HttpServer httpServer, @Qualifier(value="debugHttpRequestDispatcher") HttpRequestDispatcher requestDispatcher) {
        if (this.jupiterMode) {
            return new DebugHttpProtocolVerticle(httpServer, requestDispatcher);
        }
        return new DebugReactorVerticle();
    }
}

