/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.debug.handlers.api;

import io.gravitee.el.TemplateVariableProvider;
import io.gravitee.gateway.core.component.ComponentProvider;
import io.gravitee.gateway.core.endpoint.lifecycle.GroupLifecycleManager;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.reactor.handler.context.PathTransformer;
import io.gravitee.gateway.env.RequestTimeoutConfiguration;
import io.gravitee.gateway.handlers.api.definition.Api;
import io.gravitee.gateway.jupiter.api.hook.SecurityPlanHook;
import io.gravitee.gateway.jupiter.api.invoker.Invoker;
import io.gravitee.gateway.jupiter.core.context.MutableExecutionContext;
import io.gravitee.gateway.jupiter.debug.invoker.DebugInvokerHook;
import io.gravitee.gateway.jupiter.debug.policy.DebugPolicyHook;
import io.gravitee.gateway.jupiter.handlers.api.SyncApiReactor;
import io.gravitee.gateway.jupiter.handlers.api.flow.FlowChainFactory;
import io.gravitee.gateway.jupiter.handlers.api.processor.ApiProcessorChainFactory;
import io.gravitee.gateway.jupiter.policy.PolicyManager;
import io.gravitee.gateway.resource.ResourceLifecycleManager;
import io.gravitee.node.api.Node;
import io.gravitee.node.api.configuration.Configuration;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;

public class DebugSyncApiReactor
extends SyncApiReactor {
    public DebugSyncApiReactor(Api api, ComponentProvider componentProvider, List<TemplateVariableProvider> templateVariableProviders, Invoker defaultInvoker, ResourceLifecycleManager resourceLifecycleManager, ApiProcessorChainFactory apiProcessorChainFactory, PolicyManager policyManager, FlowChainFactory flowChainFactory, GroupLifecycleManager groupLifecycleManager, Configuration configuration, Node node, RequestTimeoutConfiguration requestTimeoutConfiguration) {
        super(api, componentProvider, templateVariableProviders, defaultInvoker, resourceLifecycleManager, apiProcessorChainFactory, policyManager, flowChainFactory, groupLifecycleManager, configuration, node, requestTimeoutConfiguration);
        this.invokerHooks.add(new DebugInvokerHook());
    }

    public Completable handle(MutableExecutionContext ctx) {
        String debugContextPath = ctx.request().contextPath();
        String cleanContextPath = PathTransformer.removeEventIdFromPath(((DebugApi)this.api).getEventId(), debugContextPath);
        ctx.request().contextPath(cleanContextPath);
        String debugPath = ctx.request().path();
        String cleanPath = PathTransformer.removeEventIdFromPath(((DebugApi)this.api).getEventId(), debugPath);
        String pathInfo = cleanPath.substring(cleanContextPath.length() == 1 ? 0 : cleanContextPath.length() - 1);
        ctx.request().pathInfo(pathInfo);
        return super.handle(ctx);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.securityChain.addHooks((Object[])new SecurityPlanHook[]{new DebugPolicyHook()});
    }
}

