/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.common.http.IdGenerator;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.debug.vertx.VertxHttpServerRequestDebugDecorator;
import io.gravitee.gateway.http.vertx.VertxHttp2ServerRequest;
import io.gravitee.gateway.http.vertx.VertxHttpServerRequest;
import io.gravitee.gateway.http.vertx.grpc.VertxGrpcServerRequest;
import io.gravitee.gateway.reactor.Reactor;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;

public class VertxDebugReactorHandler
implements Handler<HttpServerRequest> {
    private final Reactor reactor;
    private final IdGenerator idGenerator;

    public VertxDebugReactorHandler(Reactor reactor, IdGenerator idGenerator) {
        this.reactor = reactor;
        this.idGenerator = idGenerator;
    }

    public void handle(HttpServerRequest httpServerRequest) {
        Object request = httpServerRequest.version() == HttpVersion.HTTP_2 ? ("application/grpc".equals(httpServerRequest.getHeader("Content-Type")) ? new VertxGrpcServerRequest(httpServerRequest, this.idGenerator) : new VertxHttp2ServerRequest(httpServerRequest, this.idGenerator)) : new VertxHttpServerRequest(httpServerRequest, this.idGenerator);
        request = new VertxHttpServerRequestDebugDecorator((VertxHttpServerRequest)request, this.idGenerator);
        this.route((Request)request, request.createResponse());
    }

    protected void route(Request request, Response response) {
        this.reactor.route(request, response, __ -> {});
    }
}

