/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.debug.policy.steps;

import com.google.common.base.Stopwatch;
import io.gravitee.definition.model.debug.DebugStepError;
import io.gravitee.definition.model.debug.DebugStepStatus;
import io.gravitee.gateway.debug.reactor.handler.context.AttributeHelper;
import io.gravitee.gateway.jupiter.api.ExecutionFailure;
import io.gravitee.gateway.jupiter.api.ExecutionPhase;
import io.gravitee.gateway.jupiter.debug.policy.steps.PolicyStepState;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public abstract class PolicyStep<T> {
    public static final String DIFF_KEY_HEADERS = "headers";
    public static final String DIFF_KEY_PARAMETERS = "parameters";
    public static final String DIFF_KEY_PATH = "path";
    public static final String DIFF_KEY_PATH_PARAMETERS = "pathParameters";
    public static final String DIFF_KEY_METHOD = "method";
    public static final String DIFF_KEY_CONTEXT_PATH = "contextPath";
    public static final String DIFF_KEY_ATTRIBUTES = "attributes";
    public static final String DIFF_KEY_BODY_BUFFER = "bodyBuffer";
    public static final String DIFF_KEY_BODY = "body";
    public static final String DIFF_KEY_STATUS_CODE = "statusCode";
    public static final String DIFF_KEY_REASON = "reason";
    protected final String id = UUID.randomUUID().toString();
    protected final String policyId;
    protected final ExecutionPhase executionPhase;
    protected final String flowPhase;
    protected final Stopwatch stopwatch;
    protected DebugStepStatus status;
    protected String condition;
    protected DebugStepError error;
    protected boolean ended = false;
    private PolicyStepState inputState;
    private Map<String, Object> diffMap;

    protected PolicyStep(String policyId, ExecutionPhase executionPhase, String flowPhase) {
        this.policyId = policyId;
        this.executionPhase = executionPhase;
        this.flowPhase = flowPhase;
        this.stopwatch = Stopwatch.createUnstarted();
    }

    public Completable pre(T source, Map<String, Object> attributes) {
        return this.saveInputState(source, AttributeHelper.filterAndSerializeAttributes(attributes)).doOnSuccess(policyStepState -> {
            this.inputState = policyStepState;
            this.starTimeWatch();
        }).ignoreElement();
    }

    protected abstract Single<PolicyStepState> saveInputState(T var1, Map<String, Serializable> var2);

    public Completable post(T source, Map<String, Object> attributes) {
        return Completable.fromRunnable(this::stopTimeWatch).andThen(this.computeDiff(source, this.inputState, AttributeHelper.filterAndSerializeAttributes(attributes))).doOnSuccess(computedDiffMap -> {
            this.diffMap = computedDiffMap;
            this.inputState = null;
            this.status = this.status == null ? DebugStepStatus.COMPLETED : this.status;
        }).ignoreElement();
    }

    protected abstract Single<Map<String, Object>> computeDiff(T var1, PolicyStepState var2, Map<String, Serializable> var3);

    public Map<String, Object> getDiff() {
        if (this.diffMap == null) {
            this.diffMap = new HashMap<String, Object>();
        }
        return this.diffMap;
    }

    protected PolicyStepState getInputState() {
        return this.inputState;
    }

    protected void starTimeWatch() {
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
        }
    }

    protected void stopTimeWatch() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
    }

    public Completable error(Throwable ex) {
        return Completable.fromRunnable(() -> {
            this.stopTimeWatch();
            this.status = DebugStepStatus.ERROR;
            this.error = new DebugStepError();
            this.error.setMessage(ex.getMessage());
        });
    }

    public Completable error(ExecutionFailure executionFailure) {
        return Completable.fromRunnable(() -> {
            this.stopTimeWatch();
            this.status = DebugStepStatus.ERROR;
            this.error = new DebugStepError();
            this.error.setMessage(executionFailure.message());
            this.error.setKey(executionFailure.key());
            this.error.setStatus(executionFailure.statusCode());
            this.error.setContentType(executionFailure.contentType());
        });
    }

    public void onConditionFilter(String condition, boolean isConditionTruthy) {
        this.condition = condition;
        if (!isConditionTruthy) {
            this.status = DebugStepStatus.SKIPPED;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public ExecutionPhase getExecutionPhase() {
        return this.executionPhase;
    }

    public String getFlowPhase() {
        return this.flowPhase;
    }

    public Duration elapsedTime() {
        return this.stopwatch.elapsed();
    }

    public DebugStepStatus getStatus() {
        return this.status;
    }

    public String getCondition() {
        return this.condition;
    }

    public DebugStepError getError() {
        return this.error;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void end() {
        this.ended = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyStep that = (PolicyStep)o;
        return this.ended == that.ended && Objects.equals(this.id, that.id) && Objects.equals(this.policyId, that.policyId) && this.executionPhase == that.executionPhase && Objects.equals(this.flowPhase, that.flowPhase) && Objects.equals(this.stopwatch, that.stopwatch) && this.status == that.status && Objects.equals(this.condition, that.condition) && Objects.equals(this.error, that.error) && Objects.equals(this.inputState, that.inputState) && Objects.equals(this.diffMap, that.diffMap);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.policyId, this.executionPhase, this.flowPhase, this.stopwatch, this.status, this.condition, this.error, this.ended, this.inputState, this.diffMap);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + "'policyId='" + this.policyId + "', executionPhase=" + this.executionPhase + ", stopwatch=" + this.stopwatch.elapsed(TimeUnit.NANOSECONDS) + " ns, diffMap='" + this.diffMap + "'}";
    }
}

