/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.debug;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.HttpRequest;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.gateway.debug.definition.DebugApi;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.platform.Organization;
import io.gravitee.gateway.platform.manager.OrganizationManager;
import io.gravitee.gateway.reactor.Reactable;
import io.gravitee.gateway.reactor.ReactorEvent;
import io.gravitee.gateway.reactor.handler.ReactorEventListener;
import io.gravitee.gateway.reactor.handler.ReactorHandlerRegistry;
import io.gravitee.gateway.reactor.impl.ReactableWrapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpClientResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReactorEventListener
extends ReactorEventListener {
    private final Logger logger = LoggerFactory.getLogger(DebugReactorEventListener.class);
    private final Vertx vertx;
    private final EventManager eventManager;
    private final EventRepository eventRepository;
    private final ObjectMapper objectMapper;
    private final VertxDebugHttpClientConfiguration debugHttpClientConfiguration;
    private final ReactorHandlerRegistry reactorHandlerRegistry;
    private final OrganizationManager organizationManager;

    public DebugReactorEventListener(Vertx vertx, EventManager eventManager, EventRepository eventRepository, ObjectMapper objectMapper, VertxDebugHttpClientConfiguration debugHttpClientConfiguration, ReactorHandlerRegistry reactorHandlerRegistry, OrganizationManager organizationManager) {
        super(eventManager, reactorHandlerRegistry);
        this.vertx = vertx;
        this.eventManager = eventManager;
        this.eventRepository = eventRepository;
        this.objectMapper = objectMapper;
        this.debugHttpClientConfiguration = debugHttpClientConfiguration;
        this.reactorHandlerRegistry = reactorHandlerRegistry;
        this.organizationManager = organizationManager;
    }

    public void onEvent(io.gravitee.common.event.Event<ReactorEvent, Reactable> reactorEvent) {
        if (reactorEvent.type() == ReactorEvent.DEBUG) {
            this.logger.info("Deploying api for debug");
            ReactableWrapper reactableWrapper = (ReactableWrapper)reactorEvent.content();
            Event debugEvent = (Event)reactableWrapper.getContent();
            DebugApi debugApi = this.toDebugApi(debugEvent);
            if (debugApi != null) {
                if (this.reactorHandlerRegistry.contains((Reactable)debugApi)) {
                    this.logger.info("Api for debug already deployed. No need to do it again.");
                    return;
                }
                try {
                    this.reactorHandlerRegistry.create((Reactable)debugApi);
                    HttpRequest debugApiRequest = debugApi.getRequest();
                    this.updateEvent(debugEvent, ApiDebugStatus.DEBUGGING);
                    this.logger.info("Sending request to debug");
                    this.vertx.createHttpClient(this.buildClientOptions()).rxRequest(new RequestOptions().setMethod(HttpMethod.valueOf((String)debugApiRequest.getMethod())).setHeaders(this.buildHeaders(debugApi, debugApiRequest)).setURI(((VirtualHost)((Api)debugApi.getDefinition()).getProxy().getVirtualHosts().get(0)).getPath() + debugApiRequest.getPath()).setTimeout((long)this.debugHttpClientConfiguration.getRequestTimeout())).map(httpClientRequest -> httpClientRequest.setChunked(true)).flatMap(httpClientRequest -> debugApiRequest.getBody() == null ? httpClientRequest.rxSend() : httpClientRequest.rxSend(debugApiRequest.getBody())).doOnSuccess(httpClientResponse -> this.logger.debug("Response status: {}", (Object)httpClientResponse.statusCode())).flatMap(HttpClientResponse::rxBody).subscribe(body -> {
                        this.logger.info("Debugging successful, removing the handler.");
                        this.reactorHandlerRegistry.remove((Reactable)debugApi);
                    }, throwable -> {
                        this.logger.error("Debugging API has failed, removing the handler.", throwable);
                        this.reactorHandlerRegistry.remove((Reactable)debugApi);
                        this.failEvent(debugEvent);
                    });
                }
                catch (TechnicalException e) {
                    this.logger.error("An error occurred when debugging api for event {}, removing the handler.", (Object)debugApi.getEventId(), (Object)e);
                    this.reactorHandlerRegistry.remove((Reactable)debugApi);
                    this.failEvent(debugEvent);
                }
            }
        }
    }

    private DebugApi toDebugApi(Event event) {
        try {
            io.gravitee.definition.model.debug.DebugApi eventPayload = (io.gravitee.definition.model.debug.DebugApi)this.objectMapper.readValue(event.getPayload(), io.gravitee.definition.model.debug.DebugApi.class);
            DebugApi debugApi = new DebugApi(event.getId(), eventPayload);
            debugApi.setEnabled(true);
            debugApi.setDeployedAt(new Date());
            Organization currentOrganization = this.organizationManager.getCurrentOrganization();
            if (currentOrganization != null) {
                debugApi.setOrganizationId(currentOrganization.getId());
            }
            return debugApi;
        }
        catch (Exception e) {
            this.logger.error("Unable to extract api definition from event [{}].", (Object)event.getId(), (Object)e);
            this.failEvent(event);
            return null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.eventManager.subscribeForEvents((EventListener)this, ReactorEvent.class);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.reactorHandlerRegistry.clear();
    }

    private HttpClientOptions buildClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        options.setDefaultHost(this.debugHttpClientConfiguration.getHost());
        options.setDefaultPort(this.debugHttpClientConfiguration.getPort());
        options.setConnectTimeout(this.debugHttpClientConfiguration.getConnectTimeout());
        options.setTryUseCompression(this.debugHttpClientConfiguration.isCompressionSupported());
        options.setUseAlpn(this.debugHttpClientConfiguration.isAlpn());
        options.setVerifyHost(false);
        if (this.debugHttpClientConfiguration.isSecured()) {
            options.setSsl(this.debugHttpClientConfiguration.isSecured());
            options.setTrustAll(true);
            if (this.debugHttpClientConfiguration.isOpenssl()) {
                options.setSslEngineOptions((SSLEngineOptions)new OpenSSLEngineOptions());
            }
        }
        return options;
    }

    private MultiMap buildHeaders(DebugApi debugApi, HttpRequest req) {
        String host;
        HeadersMultiMap headers = new HeadersMultiMap();
        if (((Api)debugApi.getDefinition()).getProxy().getVirtualHosts().size() > 1 && (host = ((VirtualHost)((Api)debugApi.getDefinition()).getProxy().getVirtualHosts().get(0)).getHost()) != null) {
            headers.add("Host", host);
        }
        return headers.addAll(this.convertHeaders(req.getHeaders()));
    }

    MultiMap convertHeaders(Map<String, List<String>> headers) {
        HeadersMultiMap headersMultiMap = new HeadersMultiMap();
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HeadersMultiMap)headersMultiMap).set(arg_0, arg_1));
        }
        return headersMultiMap;
    }

    private void failEvent(Event debugEvent) {
        try {
            if (debugEvent != null) {
                this.updateEvent(debugEvent, ApiDebugStatus.ERROR);
            }
        }
        catch (TechnicalException e) {
            this.logger.error("Error when updating event {}", (Object)debugEvent.getId(), (Object)e);
        }
    }

    private void updateEvent(Event debugEvent, ApiDebugStatus apiDebugStatus) throws TechnicalException {
        debugEvent.getProperties().put(Event.EventProperties.API_DEBUG_STATUS.getValue(), apiDebugStatus.name());
        this.eventRepository.update((Object)debugEvent);
    }
}

