/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.jupiter.debug.vertx;

import io.gravitee.gateway.jupiter.reactor.HttpRequestDispatcher;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.vertx.core.http.HttpServer;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.HttpServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DebugHttpProtocolVerticle
extends AbstractVerticle {
    private final Logger log = LoggerFactory.getLogger(DebugHttpProtocolVerticle.class);
    private final io.vertx.reactivex.core.http.HttpServer rxHttpServer;
    private final HttpRequestDispatcher requestDispatcher;
    private Disposable requestDisposable;

    public DebugHttpProtocolVerticle(@Qualifier(value="debugGatewayHttpServer") HttpServer httpServer, @Qualifier(value="debugHttpRequestDispatcher") HttpRequestDispatcher requestDispatcher) {
        this.rxHttpServer = io.vertx.reactivex.core.http.HttpServer.newInstance((HttpServer)httpServer);
        this.requestDispatcher = requestDispatcher;
    }

    public Completable rxStart() {
        this.requestDisposable = this.rxHttpServer.requestStream().toFlowable().flatMapCompletable(this::dispatchRequest).subscribe();
        return this.rxHttpServer.rxListen().ignoreElement().doOnComplete(() -> this.log.info("HTTP listener ready to accept requests on port {}", (Object)this.rxHttpServer.actualPort())).doOnError(throwable -> this.log.error("Unable to start HTTP Server", throwable.getCause()));
    }

    private Completable dispatchRequest(HttpServerRequest request) {
        return this.requestDispatcher.dispatch(request).doOnComplete(() -> this.log.debug("Request properly dispatched")).onErrorResumeNext(t -> this.handleError((Throwable)t, request.response())).doOnSubscribe(dispatchDisposable -> this.configureCloseHandler(request, (Disposable)dispatchDisposable));
    }

    private Completable handleError(Throwable throwable, HttpServerResponse response) {
        this.log.error("An unexpected error occurred while dispatching request", throwable);
        return this.tryEndResponse(response);
    }

    private Completable tryEndResponse(HttpServerResponse response) {
        try {
            if (!response.ended()) {
                if (!response.headWritten()) {
                    response.setStatusCode(500);
                }
                return response.rxEnd().doOnError(throwable -> this.log.error("Failed to properly end response after error", throwable)).onErrorComplete();
            }
            return Completable.complete();
        }
        catch (Throwable throwable2) {
            this.log.error("Failed to properly end response after error", throwable2);
            return Completable.complete();
        }
    }

    private void configureCloseHandler(HttpServerRequest request, Disposable dispatchDisposable) {
        request.connection().closeHandler(event -> dispatchDisposable.dispose());
    }

    public Completable rxStop() {
        this.log.info("Stopping HTTP Server...");
        return Completable.fromRunnable(() -> ((Disposable)this.requestDisposable).dispose()).andThen((CompletableSource)this.rxHttpServer.rxClose().doOnComplete(() -> this.log.info("HTTP Server has been correctly stopped")));
    }
}

