/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.debug.vertx.DebugReactorVerticle;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class VertxDebugService
extends AbstractService {
    private final Logger logger = LoggerFactory.getLogger(VertxDebugService.class);
    @Autowired
    private Vertx vertx;
    private String deploymentId;

    public VertxDebugService start() {
        this.doStart();
        return this;
    }

    public VertxDebugService stop() {
        this.doStop();
        return this;
    }

    protected void doStart() {
        this.logger.info("Starting Vertx DEBUG container and deploy 1 Debug Reactor Verticle");
        DebugReactorVerticle debugReactorVerticle = new DebugReactorVerticle();
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)debugReactorVerticle);
        this.vertx.deployVerticle((Verticle)debugReactorVerticle, event -> {
            if (event.failed()) {
                this.logger.warn("Unable to start Debug HTTP server", event.cause());
            } else {
                this.deploymentId = (String)event.result();
            }
        });
    }

    protected void doStop() {
        if (this.deploymentId != null) {
            this.vertx.undeploy(this.deploymentId, event -> this.lifecycle.moveToStopped());
        }
    }
}

