/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug.vertx;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.gateway.debug.reactor.DebugReactor;
import io.gravitee.gateway.debug.reactor.processor.DebugResponseProcessorChainFactory;
import io.gravitee.gateway.debug.vertx.DebugReactorVerticle;
import io.gravitee.gateway.debug.vertx.VertxDebugHttpClientConfiguration;
import io.gravitee.gateway.reactor.Reactor;
import io.gravitee.gateway.reactor.handler.EntrypointResolver;
import io.gravitee.gateway.reactor.processor.NotFoundProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.RequestProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.ResponseProcessorChainFactory;
import io.gravitee.gateway.reactor.processor.transaction.TraceContextProcessorFactory;
import io.gravitee.gateway.reactor.processor.transaction.TransactionRequestProcessorFactory;
import io.gravitee.node.certificates.KeyStoreLoaderManager;
import io.gravitee.node.vertx.VertxHttpServerFactory;
import io.gravitee.node.vertx.configuration.HttpServerConfiguration;
import io.gravitee.repository.management.api.EventRepository;
import io.vertx.core.Vertx;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
public class VertxDebugConfiguration {
    @Bean
    @Scope(value="prototype")
    public DebugReactorVerticle graviteeDebugVerticle() {
        return new DebugReactorVerticle();
    }

    @Bean
    public Reactor reactor(@Qualifier(value="debugEntryPointResolver") EntrypointResolver entrypointResolver, @Qualifier(value="debugRequestProcessorChainFactory") RequestProcessorChainFactory requestProcessorChainFactory, @Qualifier(value="debugResponseProcessorChainFactory") ResponseProcessorChainFactory responseProcessorChainFactory) {
        return new DebugReactor(entrypointResolver, requestProcessorChainFactory, responseProcessorChainFactory);
    }

    @Bean
    public TransactionRequestProcessorFactory transactionHandlerFactory() {
        return new TransactionRequestProcessorFactory();
    }

    @Bean
    public TraceContextProcessorFactory traceContextHandlerFactory() {
        return new TraceContextProcessorFactory();
    }

    @Bean
    @Qualifier(value="debugRequestProcessorChainFactory")
    public RequestProcessorChainFactory requestProcessorChainFactory() {
        return new RequestProcessorChainFactory();
    }

    @Bean
    @Qualifier(value="debugResponseProcessorChainFactory")
    public ResponseProcessorChainFactory responseProcessorChainFactory(EventRepository eventRepository, ObjectMapper objectMapper) {
        return new DebugResponseProcessorChainFactory(eventRepository, objectMapper);
    }

    @Bean
    public NotFoundProcessorChainFactory notFoundProcessorChainFactory() {
        return new NotFoundProcessorChainFactory();
    }

    @Bean(value={"debugHttpServerConfiguration"})
    public HttpServerConfiguration debugHttpServerConfiguration(Environment environment) {
        return HttpServerConfiguration.builder().withEnvironment(environment).withPort(Integer.parseInt(environment.getProperty("debug.port", "8482"))).withHost(environment.getProperty("debug.host", "localhost")).withDefaultSecured(Boolean.TRUE.equals(environment.getProperty("http.secured", Boolean.class))).withDefaultAlpn(Boolean.TRUE.equals(environment.getProperty("http.alpn", Boolean.class))).withDefaultOpenssl(Boolean.TRUE.equals(environment.getProperty("http.ssl.openssl", Boolean.class))).build();
    }

    @Bean(value={"gatewayDebugHttpServer"})
    public VertxHttpServerFactory vertxHttpServerFactory(Vertx vertx, @Qualifier(value="debugHttpServerConfiguration") HttpServerConfiguration httpServerConfiguration, KeyStoreLoaderManager keyStoreLoaderManager) {
        return new VertxHttpServerFactory(vertx, httpServerConfiguration, keyStoreLoaderManager);
    }

    @Bean(value={"debugHttpClientConfiguration"})
    public VertxDebugHttpClientConfiguration debugHttpClientConfiguration() {
        return new VertxDebugHttpClientConfiguration();
    }
}

