/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.debug;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.service.AbstractService;
import io.gravitee.common.util.ListReverser;
import io.gravitee.gateway.debug.reactor.DebugReactor;
import io.gravitee.gateway.debug.vertx.VertxDebugService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugService
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(DebugService.class);

    protected void doStart() throws Exception {
        super.doStart();
        List<Class<? extends LifecycleComponent>> components = this.components();
        Iterator<Class<? extends LifecycleComponent>> iterator = components.iterator();
        while (iterator.hasNext()) {
            Class<? extends LifecycleComponent> component;
            Class<? extends LifecycleComponent> componentClass = component = iterator.next();
            logger.info("Starting component: {}", (Object)componentClass.getSimpleName());
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                lifecyclecomponent.start();
            }
            catch (Exception exception) {
                logger.error("An error occurs while starting component {}", (Object)componentClass.getSimpleName(), (Object)exception);
                throw exception;
            }
        }
    }

    private List<Class<? extends LifecycleComponent>> components() {
        ArrayList<Class<? extends LifecycleComponent>> components = new ArrayList<Class<? extends LifecycleComponent>>();
        components.add(VertxDebugService.class);
        components.add(DebugReactor.class);
        return components;
    }

    protected void doStop() throws Exception {
        super.doStop();
        logger.info("{} is stopping", (Object)this.name());
        ListReverser components = new ListReverser(this.components());
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            Class component;
            Class componentClass = component = (Class)iterator.next();
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                if (lifecyclecomponent.lifecycleState() != Lifecycle.State.STARTED) continue;
                logger.info("Stopping component: {}", (Object)componentClass.getSimpleName());
                lifecyclecomponent.stop();
            }
            catch (Exception exception) {
                logger.error("An error occurs while stopping component {}", (Object)componentClass.getSimpleName(), (Object)exception);
            }
        }
        logger.info("{} stopped", (Object)this.name());
    }

    public String name() {
        return "Gateway - Debug service";
    }
}

